/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dirigible.engine.js.graalvm.processor.truffle;

import java.io.IOException;
import java.net.URI;
import java.nio.channels.SeekableByteChannel;
import java.nio.charset.StandardCharsets;
import java.nio.file.AccessMode;
import java.nio.file.DirectoryStream;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.apache.commons.compress.utils.SeekableInMemoryByteChannel;
import org.eclipse.dirigible.commons.api.scripting.ScriptingException;
import org.eclipse.dirigible.engine.api.script.IScriptEngineExecutor;
import org.eclipse.dirigible.engine.js.graalvm.processor.truffle.DirigibleScopePathHandler;
import org.eclipse.dirigible.engine.js.graalvm.processor.truffle.StandardPathHandler;
import org.graalvm.polyglot.io.FileSystem;

public class RegistryTruffleFileSystem
implements FileSystem {
    private final DirigibleScopePathHandler scopeHandler;
    private final StandardPathHandler standardHandler;

    public RegistryTruffleFileSystem(IScriptEngineExecutor executor, String project) {
        this.scopeHandler = new DirigibleScopePathHandler(executor);
        this.standardHandler = new StandardPathHandler(project, "/registry/public", executor);
    }

    public Path parsePath(URI uri) {
        throw new ScriptingException("URIs are currently not supported!");
    }

    public Path parsePath(String path) {
        if ("".equals(path)) {
            return Path.of("", new String[0]);
        }
        return this.standardHandler.handlePossibleRepositoryPath(path);
    }

    public void checkAccess(Path path, Set<? extends AccessMode> modes, LinkOption ... linkOptions) throws IOException {
    }

    public void createDirectory(Path dir, FileAttribute<?> ... attrs) throws IOException {
    }

    public void delete(Path path) throws IOException {
    }

    public SeekableByteChannel newByteChannel(Path path, Set<? extends OpenOption> options, FileAttribute<?> ... attrs) throws IOException {
        String pathString = path.toString().replace("\\", "/");
        String source = this.scopeHandler.resolve(pathString);
        if (!source.isEmpty()) {
            return new SeekableInMemoryByteChannel(source.getBytes(StandardCharsets.UTF_8));
        }
        source = this.standardHandler.resolve(pathString);
        return new SeekableInMemoryByteChannel(source.getBytes(StandardCharsets.UTF_8));
    }

    public DirectoryStream<Path> newDirectoryStream(Path dir, DirectoryStream.Filter<? super Path> filter) throws IOException {
        return null;
    }

    public Path toAbsolutePath(Path path) {
        if ("".equals(path.toString())) {
            return Path.of("", new String[0]);
        }
        Path maybeDirigiblePath = this.standardHandler.handlePossibleRepositoryPath(path);
        return maybeDirigiblePath.toAbsolutePath();
    }

    public Path toRealPath(Path path, LinkOption ... linkOptions) throws IOException {
        if ("".equals(path.toString())) {
            return Path.of("", new String[0]);
        }
        return this.standardHandler.handlePossibleRepositoryPath(path);
    }

    public Map<String, Object> readAttributes(Path path, String attributes, LinkOption ... options) throws IOException {
        HashMap<String, Object> attr = new HashMap<String, Object>();
        attr.put("isRegularFile", true);
        return attr;
    }
}

