/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dirigible.engine.js.graalvm.processor.truffle;

import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.nio.file.Paths;
import org.eclipse.dirigible.engine.api.script.IScriptEngineExecutor;
import org.eclipse.dirigible.engine.api.script.Module;

class StandardPathHandler {
    private final String project;
    private final String root;
    private final IScriptEngineExecutor executor;

    StandardPathHandler(String project, String root, IScriptEngineExecutor executor) {
        this.project = "/" + project;
        this.root = root;
        this.executor = executor;
    }

    Path handlePossibleRepositoryPath(String path) {
        return this.handlePossibleRepositoryPath(Paths.get(path, new String[0]));
    }

    Path handlePossibleRepositoryPath(Path path) {
        String pathString = path.toString();
        String maybeDirigibleScope = this.tryExtractDirigibleScope(pathString = pathString.replace("\\", "/"));
        if (maybeDirigibleScope != null) {
            return Paths.get(maybeDirigibleScope, new String[0]);
        }
        if (pathString.startsWith("./") || pathString.startsWith("../")) {
            return Path.of(this.project, pathString);
        }
        if (pathString.startsWith("/") || pathString.charAt(1) == ':') {
            return path;
        }
        return Path.of("/" + pathString, new String[0]);
    }

    String resolve(String pathString) {
        pathString = this.trimPathExtension(pathString);
        Module module = this.getModuleFromRepository(this.root, pathString, this.executor);
        return new String(module.getContent(), StandardCharsets.UTF_8);
    }

    private String trimPathExtension(String pathString) {
        if (this.hasExtension(pathString, ".js")) {
            pathString = pathString.replace(".js", "");
        }
        if (this.hasExtension(pathString, ".mjs")) {
            pathString = pathString.replace(".mjs", "");
        }
        return pathString;
    }

    private boolean hasExtension(String path, String extension) {
        return path.toLowerCase().endsWith(extension);
    }

    private Module getModuleFromRepository(String root, String pathString, IScriptEngineExecutor executor) {
        return executor.retrieveModule(root, pathString, ".mjs");
    }

    private String tryExtractDirigibleScope(String pathString) {
        int maybeDirigibleScopeIndex = pathString.indexOf("/@dirigible/");
        if (maybeDirigibleScopeIndex == -1) {
            return null;
        }
        return pathString.substring(maybeDirigibleScopeIndex);
    }
}

