/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dirigible.engine.js.graalvm.service;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import io.swagger.annotations.Authorization;
import javax.servlet.http.HttpServletResponse;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import org.eclipse.dirigible.api.v3.security.UserFacade;
import org.eclipse.dirigible.commons.api.service.AbstractRestService;
import org.eclipse.dirigible.commons.api.service.IRestService;
import org.eclipse.dirigible.engine.js.graalvm.debugger.GraalVMJavascriptDebugProcessor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Path(value="/ide/debug/graalvm")
@Api(value="JavaScript Engine Debugger - GraalVM", authorizations={@Authorization(value="basicAuth", scopes={})})
@ApiResponses(value={@ApiResponse(code=401, message="Unauthorized"), @ApiResponse(code=403, message="Forbidden"), @ApiResponse(code=404, message="Not Found"), @ApiResponse(code=500, message="Internal Server Error")})
public class GraalVMJavascriptEngineDebugRestService
extends AbstractRestService
implements IRestService {
    private static final Logger logger = LoggerFactory.getLogger(GraalVMJavascriptEngineDebugRestService.class);
    @Context
    private HttpServletResponse response;

    @GET
    @Path(value="/enable")
    @Produces(value={"application/json"})
    @ApiOperation(value="Enable debugging")
    @ApiResponses(value={@ApiResponse(code=200, message="Execution Result")})
    public Response enable() {
        String user = UserFacade.getName();
        if (user == null) {
            return this.createErrorResponseForbidden("No logged in user");
        }
        GraalVMJavascriptDebugProcessor.addUserSession(user);
        return Response.ok().build();
    }

    @GET
    @Path(value="/disable")
    @Produces(value={"application/json"})
    @ApiOperation(value="Disable debugging")
    @ApiResponses(value={@ApiResponse(code=200, message="Execution Result")})
    public Response disable() {
        String user = UserFacade.getName();
        if (user == null) {
            return this.createErrorResponseForbidden("No logged in user");
        }
        GraalVMJavascriptDebugProcessor.clear();
        return Response.ok().build();
    }

    public Class<? extends IRestService> getType() {
        return GraalVMJavascriptEngineDebugRestService.class;
    }

    protected Logger getLogger() {
        return logger;
    }
}

