/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dirigible.engine.js.graalvm.service;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import io.swagger.annotations.Authorization;
import javax.servlet.http.HttpServletResponse;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.HEAD;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import org.eclipse.dirigible.commons.api.scripting.ScriptingException;
import org.eclipse.dirigible.commons.api.service.AbstractRestService;
import org.eclipse.dirigible.commons.api.service.IRestService;
import org.eclipse.dirigible.engine.js.graalvm.processor.GraalVMJavascriptEngineProcessor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Path(value="/graalvm")
@Api(value="JavaScript Engine - GraalVM", authorizations={@Authorization(value="basicAuth", scopes={})})
@ApiResponses(value={@ApiResponse(code=401, message="Unauthorized"), @ApiResponse(code=403, message="Forbidden"), @ApiResponse(code=404, message="Not Found"), @ApiResponse(code=500, message="Internal Server Error")})
public class GraalVMJavascriptEngineRestService
extends AbstractRestService
implements IRestService {
    private static final Logger logger = LoggerFactory.getLogger(GraalVMJavascriptEngineRestService.class);
    private GraalVMJavascriptEngineProcessor processor = new GraalVMJavascriptEngineProcessor();
    @Context
    private HttpServletResponse response;

    @GET
    @Path(value="/{path:.*}")
    @ApiOperation(value="Execute Server Side JavaScript GraalVM Resource")
    @ApiResponses(value={@ApiResponse(code=200, message="Execution Result")})
    public Response executeGraalVMServiceGet(@PathParam(value="path") String path) throws ScriptingException {
        this.processor.executeService(path);
        return Response.ok().build();
    }

    @POST
    @Path(value="/{path:.*}")
    @ApiOperation(value="Execute Server Side JavaScript GraalVM Resource")
    @ApiResponses(value={@ApiResponse(code=200, message="Execution Result")})
    public Response executeGraalVMServicePost(@PathParam(value="path") String path) throws ScriptingException {
        return this.executeGraalVMServiceGet(path);
    }

    @PUT
    @Path(value="/{path:.*}")
    @ApiOperation(value="Execute Server Side JavaScript GraalVM Resource")
    @ApiResponses(value={@ApiResponse(code=200, message="Execution Result")})
    public Response executeGraalVMServicePut(@PathParam(value="path") String path) throws ScriptingException {
        return this.executeGraalVMServiceGet(path);
    }

    @DELETE
    @Path(value="/{path:.*}")
    @ApiOperation(value="Execute Server Side JavaScript GraalVM Resource")
    @ApiResponses(value={@ApiResponse(code=200, message="Execution Result")})
    public Response executeGraalVMServiceDelete(@PathParam(value="path") String path) throws ScriptingException {
        return this.executeGraalVMServiceGet(path);
    }

    @HEAD
    @Path(value="/{path:.*}")
    @ApiOperation(value="Execute Server Side JavaScript GraalVM Resource")
    @ApiResponses(value={@ApiResponse(code=200, message="Execution Result")})
    public Response executeGraalVMServiceHead(@PathParam(value="path") String path) throws ScriptingException {
        return this.executeGraalVMServiceGet(path);
    }

    public Class<? extends IRestService> getType() {
        return GraalVMJavascriptEngineRestService.class;
    }

    protected Logger getLogger() {
        return logger;
    }
}

