/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dirigible.engine.js.graalvm.service;

import javax.ws.rs.core.Response;
import javax.ws.rs.ext.Provider;
import org.eclipse.dirigible.commons.api.service.AbstractExceptionHandler;
import org.graalvm.polyglot.PolyglotException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Provider
public class GraalVMJavascriptExceptionHandler
extends AbstractExceptionHandler<PolyglotException> {
    private static final Logger logger = LoggerFactory.getLogger(GraalVMJavascriptExceptionHandler.class);
    private static final String IGNORE_ERROR_MESSAGE = "ReferenceError: \"exports\" is not defined";
    private static final String RESPONSE_ERROR_MESSAGE = "It is not an executable JavaScript module";
    private static final String NULL_EXCEPTION_ERROR_MESSAGE = "Exception message is null";

    public Class<? extends AbstractExceptionHandler<PolyglotException>> getType() {
        return GraalVMJavascriptExceptionHandler.class;
    }

    protected Logger getLogger() {
        return logger;
    }

    protected Response.Status getResponseStatus(PolyglotException exception) {
        return Response.Status.INTERNAL_SERVER_ERROR;
    }

    protected String getResponseMessage(PolyglotException exception) {
        if (exception.getMessage() == null) {
            return NULL_EXCEPTION_ERROR_MESSAGE;
        }
        if (!exception.getMessage().equals(IGNORE_ERROR_MESSAGE)) {
            return exception.getMessage();
        }
        return RESPONSE_ERROR_MESSAGE;
    }

    protected void logErrorMessage(Logger logger, PolyglotException exception) {
        if (exception.getMessage() == null || !exception.getMessage().equals(IGNORE_ERROR_MESSAGE)) {
            super.logErrorMessage(logger, (Throwable)exception);
        }
    }
}

