/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dirigible.engine.js.v8.callbacks;

import com.eclipsesource.v8.JavaCallback;
import com.eclipsesource.v8.V8;
import com.eclipsesource.v8.V8Array;
import com.eclipsesource.v8.V8Object;
import com.eclipsesource.v8.utils.V8ObjectUtils;
import java.lang.reflect.Array;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.dirigible.api.v3.core.JavaFacade;
import org.eclipse.dirigible.commons.api.context.ContextException;
import org.eclipse.dirigible.engine.js.v8.callbacks.JavaV8Callback;

public class JavaV8CallInstance
extends JavaV8Callback
implements JavaCallback {
    public Object invoke(V8Object receiver, V8Array parameters) {
        int i = 0;
        String uuid = (String)parameters.get(i++);
        String methodName = (String)parameters.get(i++);
        List<Object> params = this.normalizeParameters(parameters, i);
        try {
            Object result = JavaFacade.invoke((String)uuid, (String)methodName, (Object[])params.toArray(new Object[0]));
            if (result != null && result.getClass().isArray()) {
                ArrayList<Object> list = new ArrayList<Object>();
                for (int j = 0; j < Array.getLength(result); ++j) {
                    Object next = Array.get(result, j);
                    if (next instanceof Byte) {
                        list.add(Integer.valueOf(((Byte)next).byteValue()));
                        continue;
                    }
                    list.add(next);
                }
                V8Array v8Array = V8ObjectUtils.toV8Array((V8)receiver.getRuntime(), list);
                return v8Array;
            }
            Object object = result;
            return object;
        }
        catch (ClassNotFoundException | IllegalAccessException | IllegalArgumentException | NoSuchMethodException | SecurityException | InvocationTargetException | ContextException e) {
            throw new RuntimeException(e);
        }
        finally {
            parameters.release();
        }
    }
}

