/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dirigible.engine.js.v8.processor;

import com.eclipsesource.v8.JavaCallback;
import com.eclipsesource.v8.Releasable;
import com.eclipsesource.v8.V8;
import com.eclipsesource.v8.V8Array;
import com.eclipsesource.v8.V8Object;
import com.eclipsesource.v8.V8Value;
import com.eclipsesource.v8.utils.V8ObjectUtils;
import java.io.IOException;
import java.net.URISyntaxException;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.dirigible.api.v3.http.HttpRequestFacade;
import org.eclipse.dirigible.commons.api.scripting.ScriptingException;
import org.eclipse.dirigible.engine.api.resource.ResourcePath;
import org.eclipse.dirigible.engine.api.script.IScriptEngineExecutor;
import org.eclipse.dirigible.engine.js.api.AbstractJavascriptExecutor;
import org.eclipse.dirigible.engine.js.v8.callbacks.JavaV8CallInstance;
import org.eclipse.dirigible.engine.js.v8.callbacks.JavaV8CallStatic;
import org.eclipse.dirigible.engine.js.v8.callbacks.JavaV8NewInstance;
import org.eclipse.dirigible.engine.js.v8.processor.V8RepositoryModuleSourceProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class V8JavascriptEngineExecutor
extends AbstractJavascriptExecutor {
    private static final String J2V8_CALL_STATIC_FUNCTION_NAME = "j2v8call";
    private static final String J2V8_NEW_INSTANCE_FUNCTION_NAME = "j2v8instantiate";
    private static final String J2V8_CALL_INSTANCE_FUNCTION_NAME = "j2v8invoke";
    private static final Logger logger = LoggerFactory.getLogger(V8JavascriptEngineExecutor.class);
    public static final String ENGINE_NAME = "V8 JavaScript Engine";

    public Object executeServiceModule(String module, Map<Object, Object> executionContext) throws ScriptingException {
        return this.executeService(module, executionContext, true);
    }

    public Object executeServiceCode(String code, Map<Object, Object> executionContext) throws ScriptingException {
        return this.executeService(code, executionContext, false);
    }

    public Object executeService(String moduleOrCode, Map<Object, Object> executionContext, boolean isModule) throws ScriptingException {
        logger.trace("entering: executeServiceModule()");
        logger.trace("module or code=" + moduleOrCode);
        if (moduleOrCode == null) {
            throw new ScriptingException("JavaScript module name cannot be null");
        }
        if (isModule) {
            ResourcePath resourcePath = this.getResourcePath(moduleOrCode, new String[]{".js/", ".v8/"});
            moduleOrCode = resourcePath.getModule();
            if (HttpRequestFacade.isValid()) {
                HttpRequestFacade.setAttribute((String)"dirigible-rest-resource-path", (String)resourcePath.getPath());
            }
        }
        Object result = null;
        final V8RepositoryModuleSourceProvider sourceProvider = this.createRepositoryModuleSourceProvider();
        V8 v8 = V8.createV8Runtime();
        try {
            v8.add("engine", "v8");
            HashMap<String, Object> preparedMap = new HashMap<String, Object>();
            if (executionContext != null) {
                for (Map.Entry<Object, Object> entry : executionContext.entrySet()) {
                    preparedMap.put(entry.getKey().toString(), entry.getValue());
                }
            }
            V8Object v8Map = V8ObjectUtils.toV8Object((V8)v8, preparedMap);
            v8.add("context", (V8Value)v8Map);
            v8.registerJavaMethod((JavaCallback)new JavaV8CallStatic(), J2V8_CALL_STATIC_FUNCTION_NAME);
            v8.registerJavaMethod((JavaCallback)new JavaV8NewInstance(), J2V8_NEW_INSTANCE_FUNCTION_NAME);
            v8.registerJavaMethod((JavaCallback)new JavaV8CallInstance(), J2V8_CALL_INSTANCE_FUNCTION_NAME);
            v8.registerJavaMethod(new JavaCallback(){

                public Object invoke(V8Object receiver, V8Array parameters) {
                    Object modulename = parameters.get(0);
                    try {
                        return sourceProvider.loadSource((String)modulename);
                    }
                    catch (IOException | URISyntaxException e) {
                        throw new RuntimeException(e);
                    }
                }
            }, "_j2v8loadSource");
            v8.executeScript("var Require = (function(modulePath) {\tvar _loadedModules = {}; var _require = function(path) { var moduleInfo, buffered, head = '(function(exports,module,require){ ', code = '', tail = '})', line = null; moduleInfo = _loadedModules[path]; if (moduleInfo) {   return moduleInfo; } code = _j2v8loadSource(path); moduleInfo = {   loaded : false,   id : path,   exports : {},   require : _requireClosure() }; code = head + code + tail; _loadedModules[path] = moduleInfo; var compiledWrapper = null; try {   compiledWrapper = eval(code); } catch (e) {   throw new Error('Error evaluating module ' + path + ' line #' + e.lineNumber + ' : ' + e.message, path, e.lineNumber); } var parameters = [ moduleInfo.exports, /* exports */   moduleInfo, /* module */   moduleInfo.require /* require */ ]; try {   compiledWrapper.apply(moduleInfo.exports, /* this */   parameters); } catch (e) {   throw new Error('Error executing module ' + path + ' line #' + e.lineNumber + ' : ' + e.message, path, e.lineNumber); } moduleInfo.loaded = true; return moduleInfo;};var _requireClosure = function() {  return function(path) {  var module = _require(path);  return module.exports; };};return _requireClosure();});var require = Require();");
            v8.executeScript("var console = require('core/v3/console')");
            String source = isModule ? sourceProvider.loadSource(moduleOrCode) : moduleOrCode;
            result = isModule ? v8.executeScript(source) : v8.executeScript(source, moduleOrCode, 0);
            this.forceFlush();
            if (executionContext != null) {
                executionContext.putAll(V8ObjectUtils.toMap((V8Object)v8Map));
            }
            v8Map.release();
        }
        catch (Exception e) {
            throw new ScriptingException((Throwable)e);
        }
        finally {
            v8.release();
            if (result instanceof Releasable) {
                ((Releasable)result).release();
            }
        }
        logger.trace("exiting: executeServiceModule()");
        return result;
    }

    private V8RepositoryModuleSourceProvider createRepositoryModuleSourceProvider() {
        V8RepositoryModuleSourceProvider repositoryModuleSourceProvider = null;
        repositoryModuleSourceProvider = new V8RepositoryModuleSourceProvider((IScriptEngineExecutor)this, "/registry/public");
        return repositoryModuleSourceProvider;
    }

    public String getType() {
        return "v8";
    }

    public String getName() {
        return ENGINE_NAME;
    }
}

