/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dirigible.engine.js.debug.model;

import org.eclipse.dirigible.engine.js.debug.model.DebugManager;
import org.eclipse.dirigible.engine.js.debug.model.DebugModel;
import org.eclipse.dirigible.engine.js.debug.model.DebugSessionModel;
import org.eclipse.dirigible.engine.js.debug.model.IDebugController;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DebugModelFacade {
    private static final Logger logger = LoggerFactory.getLogger(DebugModelFacade.class);
    private static DebugModelFacade debugModelFacade;

    public static DebugModelFacade getInstance() {
        if (debugModelFacade == null) {
            debugModelFacade = new DebugModelFacade();
        }
        return debugModelFacade;
    }

    public DebugSessionModel getDebugSessionModel(String user, String executionId) {
        DebugSessionModel debugModel = DebugModelFacade.getDebugModel(user).getSessionByExecutionId(executionId);
        if (debugModel == null) {
            logger.warn("Getting debug session with executionId: " + executionId + " failed - no such session exists");
        }
        return debugModel;
    }

    public void removeSession(String user, String executionId) {
        DebugSessionModel session = DebugModelFacade.getDebugModel(user).getSessionByExecutionId(executionId);
        DebugModelFacade.getDebugModel(user).getSessions().remove(session);
        logger.debug("Debug session with executionId: " + executionId + " removed");
    }

    public static DebugModel getDebugModel(String user) {
        DebugModel debugModel = DebugManager.getDebugModel(user);
        if (debugModel == null) {
            logger.debug("Debug Model has not been created!");
        }
        return debugModel;
    }

    public static DebugModel createDebugModel(String user, IDebugController debugController) {
        DebugModel debugModel = new DebugModel(debugController);
        DebugManager.registerDebugModel(user, debugModel);
        return debugModel;
    }
}

