/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dirigible.engine.js.debug.model;

import org.eclipse.dirigible.engine.js.debug.model.DebugModel;
import org.eclipse.dirigible.engine.js.debug.model.DebugSessionMetadata;
import org.eclipse.dirigible.engine.js.debug.model.IDebugController;
import org.eclipse.dirigible.engine.js.debug.model.IDebugExecutor;
import org.eclipse.dirigible.engine.js.debug.model.LinebreakMetadata;
import org.eclipse.dirigible.engine.js.debug.model.VariableValuesMetadata;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DebugSessionModel {
    private static final Logger logger = LoggerFactory.getLogger(DebugSessionModel.class);
    private DebugModel model;
    private IDebugExecutor debugExecutor;
    private VariableValuesMetadata variableValuesMetadata;
    private LinebreakMetadata currentLineBreak;
    private boolean updated = true;

    DebugSessionModel(DebugModel model) {
        this.model = model;
    }

    public DebugModel getModel() {
        return this.model;
    }

    public IDebugController getDebugController() {
        this.setUpdated(true);
        return this.model.getDebugController();
    }

    public IDebugExecutor getDebugExecutor() {
        return this.debugExecutor;
    }

    public void setDebugExecutor(IDebugExecutor debugExecutor) {
        this.debugExecutor = debugExecutor;
    }

    public VariableValuesMetadata getVariableValuesMetadata() {
        return this.variableValuesMetadata;
    }

    public void setVariableValuesMetadata(VariableValuesMetadata variableValuesMetadata) {
        this.variableValuesMetadata = variableValuesMetadata;
    }

    public LinebreakMetadata getCurrentLineBreak() {
        return this.currentLineBreak;
    }

    public void setCurrentLineBreak(LinebreakMetadata currentLineBreak) {
        this.currentLineBreak = currentLineBreak;
    }

    public String getSessionId() {
        if (this.getDebugExecutor() == null) {
            logger.error("getSessionId() - Debug executor not assigned");
            return "none";
        }
        return this.getDebugExecutor().getSessionId();
    }

    public String getExecutionId() {
        if (this.getDebugExecutor() == null) {
            logger.error("getExecutionId() - Debug executor not assigned");
            return "none";
        }
        return this.getDebugExecutor().getExecutionId();
    }

    public String getUserId() {
        if (this.getDebugExecutor() == null) {
            logger.error("getUserId() - Debug executor not assigned");
            return "none";
        }
        return this.getDebugExecutor().getUserId();
    }

    public boolean isUpdated() {
        return this.updated;
    }

    public void setUpdated(boolean updated) {
        this.updated = updated;
    }

    public void release() {
        this.debugExecutor.skipAllBreakpoints();
        this.debugExecutor.continueExecution();
    }

    public DebugSessionMetadata getMetadata() {
        DebugSessionMetadata metadata = new DebugSessionMetadata(this.getSessionId(), this.getExecutionId(), this.getUserId(), this.getExecutionId() == this.model.getActiveSession().getExecutionId());
        return metadata;
    }
}

