/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dirigible.engine.js.debug.model;

public class BreakpointMetadata
implements Comparable<BreakpointMetadata> {
    private static final String SLASH = "/";
    private static final String ROW_D_PATH_S = "[row: %d | full path: %s]";
    private String fullPath;
    private Integer row;

    public BreakpointMetadata(String fullPath, Integer row) {
        this.fullPath = fullPath;
        this.row = row;
    }

    public String getFullPath() {
        return this.fullPath;
    }

    public void setFullPath(String fullPath) {
        this.fullPath = fullPath;
    }

    public Integer getRow() {
        return this.row;
    }

    public void setRow(Integer row) {
        this.row = row;
    }

    public String getFileName() {
        return this.fullPath.substring(this.fullPath.lastIndexOf(SLASH) + 1);
    }

    @Override
    public int compareTo(BreakpointMetadata that) {
        int result = 0;
        if (that != null && (result = this.getFullPath().compareTo(that.getFullPath())) == 0) {
            result = this.getRow().compareTo(that.getRow());
        }
        return result;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.fullPath == null ? 0 : this.fullPath.hashCode());
        result = 31 * result + (this.row == null ? 0 : this.row.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        BreakpointMetadata other = (BreakpointMetadata)obj;
        if (this.fullPath == null ? other.fullPath != null : !this.fullPath.equals(other.fullPath)) {
            return false;
        }
        return !(this.row == null ? other.row != null : !this.row.equals(other.row));
    }

    public String toString() {
        String message = String.format(ROW_D_PATH_S, this.row, this.fullPath);
        return message;
    }
}

