/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dirigible.engine.js.debug.model;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.dirigible.engine.js.debug.model.BreakpointMetadata;
import org.eclipse.dirigible.engine.js.debug.model.DebugModel;

public class BreakpointsMetadata {
    private transient DebugModel model;
    private Set<BreakpointMetadata> breakpointsList = new HashSet<BreakpointMetadata>();

    BreakpointsMetadata(DebugModel model) {
        this.model = model;
    }

    public DebugModel getModel() {
        return this.model;
    }

    public Set<BreakpointMetadata> getBreakpoints() {
        return this.breakpointsList;
    }

    public void setBreakpointsList(Set<BreakpointMetadata> breakpointsList) {
        this.breakpointsList = breakpointsList;
    }

    public int[] getBreakpoints(String fullPath) {
        ArrayList<BreakpointMetadata> list = new ArrayList<BreakpointMetadata>();
        for (BreakpointMetadata breakpoint : this.getBreakpoints()) {
            if (!breakpoint.getFullPath().equals(fullPath)) continue;
            list.add(breakpoint);
        }
        int[] breakpoints = new int[list.size()];
        for (int i = 0; i < list.size(); ++i) {
            breakpoints[i] = ((BreakpointMetadata)list.get(i)).getRow();
        }
        return breakpoints;
    }

    public String toString() {
        return Arrays.toString(this.breakpointsList.toArray(new BreakpointMetadata[this.breakpointsList.size()]));
    }
}

