/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dirigible.engine.js.service;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import io.swagger.annotations.Authorization;
import javax.inject.Inject;
import javax.inject.Singleton;
import javax.servlet.http.HttpServletResponse;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.HEAD;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import org.eclipse.dirigible.commons.api.scripting.ScriptingDependencyException;
import org.eclipse.dirigible.commons.api.service.AbstractRestService;
import org.eclipse.dirigible.commons.api.service.IRestService;
import org.eclipse.dirigible.engine.js.processor.JavascriptEngineProcessor;
import org.eclipse.dirigible.repository.api.RepositoryNotFoundException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
@Path(value="/js")
@Api(value="JavaScript Engine", authorizations={@Authorization(value="basicAuth", scopes={})})
@ApiResponses(value={@ApiResponse(code=401, message="Unauthorized"), @ApiResponse(code=403, message="Forbidden"), @ApiResponse(code=404, message="Not Found"), @ApiResponse(code=500, message="Internal Server Error")})
public class JavascriptEngineRestService
extends AbstractRestService
implements IRestService {
    private static final Logger logger = LoggerFactory.getLogger((String)JavascriptEngineRestService.class.getCanonicalName());
    @Inject
    private JavascriptEngineProcessor processor;
    @Context
    private HttpServletResponse response;

    @GET
    @Path(value="/{path:.*}")
    @ApiOperation(value="Execute Server Side JavaScript Resource")
    @ApiResponses(value={@ApiResponse(code=200, message="Execution Result")})
    public Response executeJavascriptServiceGet(@PathParam(value="path") String path) {
        try {
            this.processor.executeService(path);
            return Response.ok().build();
        }
        catch (ScriptingDependencyException e) {
            logger.error(e.getMessage());
            return Response.status((Response.Status)Response.Status.ACCEPTED).entity((Object)e.getMessage()).build();
        }
        catch (RepositoryNotFoundException e) {
            String message = e.getMessage() + ". Try to publish the service before execution.";
            logger.error(message);
            return Response.status((Response.Status)Response.Status.ACCEPTED).entity((Object)message).build();
        }
        catch (Throwable e) {
            String message = e.getMessage();
            logger.error(message, e);
            return this.createErrorResponseInternalServerError(message);
        }
    }

    @POST
    @Path(value="/{path:.*}")
    @ApiOperation(value="Execute Server Side JavaScript Resource")
    @ApiResponses(value={@ApiResponse(code=200, message="Execution Result")})
    public Response executeJavascriptServicePost(@PathParam(value="path") String path) {
        return this.executeJavascriptServiceGet(path);
    }

    @PUT
    @Path(value="/{path:.*}")
    @ApiOperation(value="Execute Server Side JavaScript Resource")
    @ApiResponses(value={@ApiResponse(code=200, message="Execution Result")})
    public Response executeJavascriptServicePut(@PathParam(value="path") String path) {
        return this.executeJavascriptServiceGet(path);
    }

    @DELETE
    @Path(value="/{path:.*}")
    @ApiOperation(value="Execute Server Side JavaScript Resource")
    @ApiResponses(value={@ApiResponse(code=200, message="Execution Result")})
    public Response executeJavascriptServiceDelete(@PathParam(value="path") String path) {
        return this.executeJavascriptServiceGet(path);
    }

    @HEAD
    @Path(value="/{path:.*}")
    @ApiOperation(value="Execute Server Side JavaScript Resource")
    @ApiResponses(value={@ApiResponse(code=200, message="Execution Result")})
    public Response executeJavascriptServiceHead(@PathParam(value="path") String path) {
        return this.executeJavascriptServiceGet(path);
    }

    public Class<? extends IRestService> getType() {
        return JavascriptEngineRestService.class;
    }

    protected Logger getLogger() {
        return logger;
    }
}

