/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dirigible.engine.js.processor;

import java.text.MessageFormat;
import java.util.Map;
import java.util.ServiceLoader;
import org.eclipse.dirigible.commons.api.scripting.ScriptingException;
import org.eclipse.dirigible.commons.config.Configuration;
import org.eclipse.dirigible.engine.js.api.AbstractJavascriptExecutor;
import org.eclipse.dirigible.engine.js.api.IJavascriptEngineExecutor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultJavascriptEngineExecutor
extends AbstractJavascriptExecutor
implements IJavascriptEngineExecutor {
    private static final Logger logger = LoggerFactory.getLogger(DefaultJavascriptEngineExecutor.class);
    private static final ServiceLoader<IJavascriptEngineExecutor> JAVASCRIPT_ENGINE_EXECUTORS = ServiceLoader.load(IJavascriptEngineExecutor.class);
    public static final String ENGINE_NAME = "Default JavaScript Engine";

    public String getType() {
        return "javascript";
    }

    public String getName() {
        return ENGINE_NAME;
    }

    @Override
    public Object executeServiceModule(String module, Map<Object, Object> executionContext) throws ScriptingException {
        IJavascriptEngineExecutor engine = this.getJavascriptEngine();
        return engine.executeServiceModule(module, executionContext);
    }

    public Object executeServiceCode(String code, Map<Object, Object> executionContext) throws ScriptingException {
        IJavascriptEngineExecutor engine = this.getJavascriptEngine();
        return engine.executeServiceCode(code, executionContext);
    }

    public Object evalCode(String code, Map<Object, Object> executionContext) throws ScriptingException {
        IJavascriptEngineExecutor engine = this.getJavascriptEngine();
        return engine.evalCode(code, executionContext);
    }

    public Object evalModule(String module, Map<Object, Object> executionContext) throws ScriptingException {
        IJavascriptEngineExecutor engine = this.getJavascriptEngine();
        return engine.evalModule(module, executionContext);
    }

    private IJavascriptEngineExecutor getJavascriptEngine() throws ScriptingException {
        String javascriptEngineType = Configuration.get((String)"DIRIGIBLE_JAVASCRIPT_ENGINE_TYPE_DEFAULT", (String)"graalvm");
        for (IJavascriptEngineExecutor next : JAVASCRIPT_ENGINE_EXECUTORS) {
            if (!next.getType().equals(javascriptEngineType)) continue;
            try {
                return (IJavascriptEngineExecutor)next.getClass().newInstance();
            }
            catch (IllegalAccessException | InstantiationException e) {
                logger.error(e.getMessage(), (Throwable)e);
            }
        }
        try {
            try {
                return (IJavascriptEngineExecutor)Class.forName("org.eclipse.dirigible.engine.js.graalvm.processor.GraalVMJavascriptEngineExecutor").newInstance();
            }
            catch (IllegalAccessException | InstantiationException e) {
                logger.error(e.getMessage(), (Throwable)e);
            }
        }
        catch (ClassNotFoundException e) {
            throw new ScriptingException("No Javascript Engine registered. The default GraalJS is also not available.");
        }
        logger.error(MessageFormat.format("Default Javascript Engine Executor not found.", new Object[0]));
        return null;
    }

    public Object executeMethodFromModule(String module, String memberClass, String memberClassMethod, Map<Object, Object> executionContext) {
        IJavascriptEngineExecutor engine = this.getJavascriptEngine();
        return engine.executeMethodFromModule(module, memberClass, memberClassMethod, executionContext);
    }
}

