/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dirigible.engine.js.service;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import io.swagger.annotations.Authorization;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.HEAD;
import javax.ws.rs.PATCH;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;
import org.eclipse.dirigible.commons.api.service.AbstractRestService;
import org.eclipse.dirigible.commons.api.service.IRestService;
import org.eclipse.dirigible.commons.config.Configuration;
import org.eclipse.dirigible.commons.config.StaticObjects;
import org.eclipse.dirigible.engine.js.service.DefaultJavascriptHandler;
import org.eclipse.dirigible.engine.js.service.JavascriptHandler;
import org.eclipse.dirigible.repository.api.IRepository;
import org.eclipse.dirigible.repository.api.RepositoryNotFoundException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Path(value="/js")
@Api(value="JavaScript Engine", authorizations={@Authorization(value="basicAuth", scopes={})})
@ApiResponses(value={@ApiResponse(code=401, message="Unauthorized"), @ApiResponse(code=403, message="Forbidden"), @ApiResponse(code=404, message="Not Found"), @ApiResponse(code=500, message="Internal Server Error")})
public class JavascriptRestService
extends AbstractRestService
implements IRestService {
    private static final Logger logger = LoggerFactory.getLogger((String)JavascriptRestService.class.getCanonicalName());
    private static final String DIRIGIBLE_JAVASCRIPT_HANDLER_CLASS_NAME = "DIRIGIBLE_JAVASCRIPT_HANDLER_CLASS_NAME";
    private static final String HTTP_PATH_MATCHER = "/{projectName}/{projectFilePath:.*\\.js|.*\\.mjs}";
    private static final String HTTP_PATH_WITH_PARAM_MATCHER = "/{projectName}/{projectFilePath:.*\\.js|.*\\.mjs}/{projectFilePathParam:.*}";

    @GET
    @Path(value="/{projectName}/{projectFilePath:.*\\.js|.*\\.mjs}")
    public Response get(@PathParam(value="projectName") String projectName, @PathParam(value="projectFilePath") String projectFilePath, @QueryParam(value="debug") String debug) {
        return this.executeJavaScript(projectName, projectFilePath, debug != null);
    }

    @GET
    @Path(value="/{projectName}/{projectFilePath:.*\\.js|.*\\.mjs}/{projectFilePathParam:.*}")
    public Response get(@PathParam(value="projectName") String projectName, @PathParam(value="projectFilePath") String projectFilePath, @PathParam(value="projectFilePathParam") String projectFilePathParam, @QueryParam(value="debug") String debug) {
        return this.executeJavaScript(projectName, projectFilePath, projectFilePathParam, debug != null);
    }

    @POST
    @Path(value="/{projectName}/{projectFilePath:.*\\.js|.*\\.mjs}")
    public Response post(@PathParam(value="projectName") String projectName, @PathParam(value="projectFilePath") String projectFilePath, @QueryParam(value="debug") String debug) {
        return this.executeJavaScript(projectName, projectFilePath, debug != null);
    }

    @POST
    @Path(value="/{projectName}/{projectFilePath:.*\\.js|.*\\.mjs}/{projectFilePathParam:.*}")
    public Response post(@PathParam(value="projectName") String projectName, @PathParam(value="projectFilePath") String projectFilePath, @PathParam(value="projectFilePathParam") String projectFilePathParam, @QueryParam(value="debug") String debug) {
        return this.executeJavaScript(projectName, projectFilePath, projectFilePathParam, debug != null);
    }

    @PUT
    @Path(value="/{projectName}/{projectFilePath:.*\\.js|.*\\.mjs}")
    public Response put(@PathParam(value="projectName") String projectName, @PathParam(value="projectFilePath") String projectFilePath, @QueryParam(value="debug") String debug) {
        return this.executeJavaScript(projectName, projectFilePath, debug != null);
    }

    @PUT
    @Path(value="/{projectName}/{projectFilePath:.*\\.js|.*\\.mjs}/{projectFilePathParam:.*}")
    public Response put(@PathParam(value="projectName") String projectName, @PathParam(value="projectFilePath") String projectFilePath, @PathParam(value="projectFilePathParam") String projectFilePathParam, @QueryParam(value="debug") String debug) {
        return this.executeJavaScript(projectName, projectFilePath, projectFilePathParam, debug != null);
    }

    @PATCH
    @Path(value="/{projectName}/{projectFilePath:.*\\.js|.*\\.mjs}")
    public Response patch(@PathParam(value="projectName") String projectName, @PathParam(value="projectFilePath") String projectFilePath, @QueryParam(value="debug") String debug) {
        return this.executeJavaScript(projectName, projectFilePath, debug != null);
    }

    @PATCH
    @Path(value="/{projectName}/{projectFilePath:.*\\.js|.*\\.mjs}/{projectFilePathParam:.*}")
    public Response patch(@PathParam(value="projectName") String projectName, @PathParam(value="projectFilePath") String projectFilePath, @PathParam(value="projectFilePathParam") String projectFilePathParam, @QueryParam(value="debug") String debug) {
        return this.executeJavaScript(projectName, projectFilePath, projectFilePathParam, debug != null);
    }

    @DELETE
    @Path(value="/{projectName}/{projectFilePath:.*\\.js|.*\\.mjs}")
    public Response delete(@PathParam(value="projectName") String projectName, @PathParam(value="projectFilePath") String projectFilePath, @QueryParam(value="debug") String debug) {
        return this.executeJavaScript(projectName, projectFilePath, debug != null);
    }

    @DELETE
    @Path(value="/{projectName}/{projectFilePath:.*\\.js|.*\\.mjs}/{projectFilePathParam:.*}")
    public Response delete(@PathParam(value="projectName") String projectName, @PathParam(value="projectFilePath") String projectFilePath, @PathParam(value="projectFilePathParam") String projectFilePathParam, @QueryParam(value="debug") String debug) {
        return this.executeJavaScript(projectName, projectFilePath, projectFilePathParam, debug != null);
    }

    @HEAD
    @Path(value="/{projectName}/{projectFilePath:.*\\.js|.*\\.mjs}")
    public Response head(@PathParam(value="projectName") String projectName, @PathParam(value="projectFilePath") String projectFilePath, @QueryParam(value="debug") String debug) {
        return this.executeJavaScript(projectName, projectFilePath, debug != null);
    }

    @HEAD
    @Path(value="/{projectName}/{projectFilePath:.*\\.js|.*\\.mjs}/{projectFilePathParam:.*}")
    public Response head(@PathParam(value="projectName") String projectName, @PathParam(value="projectFilePath") String projectFilePath, @PathParam(value="projectFilePathParam") String projectFilePathParam, @QueryParam(value="debug") String debug) {
        return this.executeJavaScript(projectName, projectFilePath, projectFilePathParam, debug != null);
    }

    private Response executeJavaScript(String projectName, String projectFilePath, boolean debug) {
        return this.executeJavaScript(projectName, projectFilePath, "", debug);
    }

    private Response executeJavaScript(String projectName, String projectFilePath, String projectFilePathParam, boolean debug) {
        try {
            if (!this.isValid(projectName) || !this.isValid(projectFilePath)) {
                return Response.status((Response.Status)Response.Status.FORBIDDEN).build();
            }
            this.getJavascriptHandler().handleRequest(projectName, projectFilePath, projectFilePathParam, debug);
            return Response.ok().build();
        }
        catch (RepositoryNotFoundException e) {
            String message = e.getMessage() + ". Try to publish the service before execution.";
            throw new RepositoryNotFoundException(message, (Throwable)e);
        }
    }

    private JavascriptHandler getJavascriptHandler() {
        String javascriptHandlerClassName = Configuration.get((String)DIRIGIBLE_JAVASCRIPT_HANDLER_CLASS_NAME, null);
        if (javascriptHandlerClassName == null) {
            return new DefaultJavascriptHandler();
        }
        try {
            return (JavascriptHandler)Class.forName(javascriptHandlerClassName).getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (ClassNotFoundException | IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            throw new RuntimeException("Could not use " + javascriptHandlerClassName, e);
        }
    }

    private java.nio.file.Path getDirigibleWorkingDirectory() {
        IRepository repository = (IRepository)StaticObjects.get((String)"REPOSITORY");
        String publicRegistryPath = repository.getInternalResourcePath("/registry/public");
        return java.nio.file.Path.of(publicRegistryPath, new String[0]);
    }

    public boolean isValid(String inputPath) {
        String registryPath = this.getDirigibleWorkingDirectory().toString();
        String normalizedInputPath = java.nio.file.Path.of(inputPath, new String[0]).normalize().toString();
        File file = new File(registryPath, normalizedInputPath);
        try {
            return file.getCanonicalPath().startsWith(registryPath);
        }
        catch (IOException e) {
            return false;
        }
    }

    public Class<? extends IRestService> getType() {
        return JavascriptRestService.class;
    }

    protected Logger getLogger() {
        return logger;
    }
}

