/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dirigible.engine.js.service;

import javax.ws.rs.core.Response;
import javax.ws.rs.ext.Provider;
import org.eclipse.dirigible.commons.api.scripting.ScriptingException;
import org.eclipse.dirigible.commons.api.service.AbstractExceptionHandler;
import org.eclipse.dirigible.repository.api.RepositoryNotFoundException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Provider
public class ScriptingExceptionHandler
extends AbstractExceptionHandler<ScriptingException> {
    private static final Logger logger = LoggerFactory.getLogger(ScriptingExceptionHandler.class);

    public Class<? extends AbstractExceptionHandler<ScriptingException>> getType() {
        return ScriptingExceptionHandler.class;
    }

    protected Logger getLogger() {
        return logger;
    }

    protected void logErrorMessage(Logger logger, ScriptingException exception) {
        if (!exception.getCause().getClass().equals(RepositoryNotFoundException.class)) {
            super.logErrorMessage(logger, (Throwable)exception);
        }
    }

    protected Response.Status getResponseStatus(ScriptingException exception) {
        if (exception.getCause().getClass().equals(RepositoryNotFoundException.class)) {
            return Response.Status.NOT_FOUND;
        }
        return Response.Status.INTERNAL_SERVER_ERROR;
    }

    protected String getResponseMessage(ScriptingException exception) {
        if (exception.getCause().getClass().equals(RepositoryNotFoundException.class)) {
            return exception.getCause().getMessage();
        }
        return exception.getMessage();
    }
}

