/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dirigible.engine.js.processor;

import java.util.Map;
import java.util.ServiceLoader;
import org.apache.cxf.common.util.StringUtils;
import org.eclipse.dirigible.api.v3.http.HttpRequestFacade;
import org.eclipse.dirigible.commons.api.scripting.ScriptingException;
import org.eclipse.dirigible.engine.js.api.IJavascriptEngineExecutor;
import org.eclipse.dirigible.engine.js.api.IJavascriptEngineProcessor;
import org.eclipse.dirigible.engine.js.processor.DefaultJavascriptEngineExecutor;

public class JavascriptEngineProcessor
implements IJavascriptEngineProcessor {
    private static final ServiceLoader<IJavascriptEngineExecutor> JAVASCRIPT_ENGINE_EXECUTORS = ServiceLoader.load(IJavascriptEngineExecutor.class);
    private final IJavascriptEngineExecutor engineExecutor = new DefaultJavascriptEngineExecutor();

    @Override
    public Object executeService(String module, Map<Object, Object> parameters) throws ScriptingException {
        return this.getEngineExecutor().executeServiceModule(module, parameters);
    }

    private IJavascriptEngineExecutor getEngineExecutor() {
        String headerEngineType;
        if (HttpRequestFacade.isValid() && !StringUtils.isEmpty((String)(headerEngineType = HttpRequestFacade.getHeader((String)"dirigible-js-engine")))) {
            for (IJavascriptEngineExecutor next : JAVASCRIPT_ENGINE_EXECUTORS) {
                if (!next.getType().equals(headerEngineType)) continue;
                return next;
            }
        }
        return this.engineExecutor;
    }
}

