/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dirigible.repository.api;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.dirigible.commons.config.Configuration;

public class RepositoryCache {
    private static Map<String, byte[]> cache;

    public RepositoryCache() {
        RepositoryCache.initialize();
    }

    private static void initialize() {
        if (!Boolean.parseBoolean(Configuration.get((String)"DIRIGIBLE_REPOSITORY_DISABLE_CACHE", (String)"false"))) {
            if (cache == null) {
                cache = Collections.synchronizedMap(new HashMap());
            }
        } else {
            cache = null;
        }
    }

    public byte[] get(String path) {
        if (cache != null) {
            return cache.get(path);
        }
        return null;
    }

    public void put(String path, byte[] content) {
        if (cache != null) {
            cache.put(path, content);
        }
    }

    public void remove(String path) {
        if (cache != null) {
            cache.remove(path);
        }
    }

    public void clear() {
        if (cache != null) {
            cache.clear();
        }
    }

    public static void enable() {
        Configuration.set((String)"DIRIGIBLE_REPOSITORY_DISABLE_CACHE", (String)"false");
        RepositoryCache.initialize();
    }

    public static void disable() {
        Configuration.set((String)"DIRIGIBLE_REPOSITORY_DISABLE_CACHE", (String)"true");
        RepositoryCache.initialize();
    }
}

