/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dirigible.repository.api;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.StringTokenizer;

public class RepositoryPath {
    private String path;
    private final String[] segments;

    public RepositoryPath(String path) {
        this.path = path.replace('\\', '/');
        StringTokenizer tokenizer = new StringTokenizer(this.path, "/");
        this.segments = new String[tokenizer.countTokens()];
        for (int i = 0; i < this.segments.length; ++i) {
            this.segments[i] = tokenizer.nextToken();
        }
    }

    public RepositoryPath(RepositoryPath repositoryPath) {
        this(repositoryPath.segments);
    }

    public RepositoryPath(String ... input) {
        ArrayList<String> allSegments = new ArrayList<String>();
        for (String segment : input) {
            String[] segmentParts;
            StringTokenizer tokenizer = new StringTokenizer(segment, "/");
            for (String segmentPart : segmentParts = new String[tokenizer.countTokens()]) {
                allSegments.add(tokenizer.nextToken());
            }
        }
        this.segments = allSegments.toArray(new String[0]);
        this.path = this.toString();
    }

    public String getLastSegment() {
        if (this.segments.length == 0) {
            return "";
        }
        return this.segments[this.segments.length - 1];
    }

    public RepositoryPath getParentPath() {
        if (this.segments.length == 0) {
            return null;
        }
        String[] newSegments = Arrays.copyOf(this.segments, this.segments.length - 1);
        return new RepositoryPath(newSegments);
    }

    public RepositoryPath append(String name) {
        StringTokenizer tokenizer = new StringTokenizer(name, "/");
        String[] newSegments = Arrays.copyOf(this.segments, this.segments.length + tokenizer.countTokens());
        int i = 0;
        while (tokenizer.hasMoreTokens()) {
            newSegments[this.segments.length + i++] = tokenizer.nextToken();
        }
        return new RepositoryPath(newSegments);
    }

    public String toString() {
        if (this.segments.length == 0) {
            return "/";
        }
        StringBuilder builder = new StringBuilder();
        for (String segment : this.segments) {
            if (!segment.equals("/") && segment.indexOf(58) == -1) {
                builder.append("/");
            }
            builder.append(segment);
        }
        return builder.toString();
    }

    public String build() {
        return this.toString();
    }

    public String getPath() {
        return this.path;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof RepositoryPath)) {
            return false;
        }
        RepositoryPath other = (RepositoryPath)obj;
        return this.getPath().equals(other.getPath());
    }

    public int hashCode() {
        return this.getPath().hashCode();
    }

    public String[] getSegments() {
        return Arrays.copyOf(this.segments, this.segments.length);
    }

    public String constructPathTo(int number) {
        if (number >= this.segments.length) {
            return this.toString();
        }
        if (this.segments.length == 0) {
            return "/";
        }
        StringBuilder builder = new StringBuilder();
        for (int i = 0; i < number; ++i) {
            builder.append("/");
            builder.append(this.segments[i]);
        }
        return builder.toString();
    }

    public String constructPathFrom(int number) {
        if (number >= this.segments.length) {
            return this.toString();
        }
        if (this.segments.length == 0) {
            return "/";
        }
        StringBuilder builder = new StringBuilder();
        for (int i = number; i < this.segments.length; ++i) {
            builder.append("/");
            builder.append(this.segments[i]);
        }
        return builder.toString();
    }

    public static String normalizePath(String path, String name) {
        String normalizedPath = null;
        if (path != null) {
            normalizedPath = path.endsWith("/") ? path + name : path + "/" + name;
        }
        return normalizedPath;
    }

    public static String normalizeName(String name) {
        return name.replaceAll("[^A-Za-z0-9_]", "_");
    }

    public void setSegment(int index, String value) {
        this.segments[index] = value;
    }
}

