/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dirigible.repository.api;

import java.util.Iterator;
import java.util.ServiceLoader;
import java.util.concurrent.atomic.AtomicBoolean;
import org.eclipse.dirigible.commons.config.Configuration;
import org.eclipse.dirigible.repository.api.IRepositoryCache;

public class RepositoryCache
implements IRepositoryCache {
    private static IRepositoryCache cache;
    private static final AtomicBoolean ENABLED;

    @Override
    public byte[] get(String path) {
        if (ENABLED.get() && cache != null) {
            return cache.get(path);
        }
        return null;
    }

    @Override
    public void put(String path, byte[] content) {
        if (ENABLED.get() && cache != null) {
            cache.put(path, content);
        }
    }

    @Override
    public void remove(String path) {
        if (ENABLED.get() && cache != null) {
            cache.remove(path);
        }
    }

    @Override
    public void clear() {
        if (ENABLED.get() && cache != null) {
            cache.clear();
        }
    }

    public static void enable() {
        Configuration.set((String)"DIRIGIBLE_REPOSITORY_CACHE_ENABLED", (String)Boolean.TRUE.toString());
        ENABLED.set(true);
    }

    public static void disable() {
        Configuration.set((String)"DIRIGIBLE_REPOSITORY_CACHE_ENABLED", (String)Boolean.FALSE.toString());
        ENABLED.set(false);
        if (ENABLED.get() && cache != null) {
            cache.clear();
        }
    }

    public static boolean isEnabled() {
        return ENABLED.get();
    }

    static {
        ENABLED = new AtomicBoolean(false);
        ServiceLoader<IRepositoryCache> services = ServiceLoader.load(IRepositoryCache.class);
        Iterator<IRepositoryCache> iterator = services.iterator();
        if (iterator.hasNext()) {
            IRepositoryCache next;
            cache = next = iterator.next();
        }
        ENABLED.set(Boolean.parseBoolean(Configuration.get((String)"DIRIGIBLE_REPOSITORY_CACHE_ENABLED", (String)Boolean.FALSE.toString())));
    }
}

