/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ecf.core;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.runtime.IAdapterManager;
import org.eclipse.ecf.core.ContainerConnectException;
import org.eclipse.ecf.core.IContainer;
import org.eclipse.ecf.core.IContainerListener;
import org.eclipse.ecf.core.events.IContainerEvent;
import org.eclipse.ecf.core.security.Callback;
import org.eclipse.ecf.core.security.CallbackHandler;
import org.eclipse.ecf.core.security.IConnectContext;
import org.eclipse.ecf.core.security.ObjectCallback;
import org.eclipse.ecf.internal.core.ECFPlugin;
import org.eclipse.ecf.internal.core.Messages;

public abstract class AbstractContainer
implements IContainer {
    protected List containerListeners = new ArrayList();

    public void addListener(IContainerListener l) {
        this.containerListeners.add(l);
    }

    public void removeListener(IContainerListener l) {
        this.containerListeners.remove(l);
    }

    public void dispose() {
    }

    protected void fireContainerEvent(IContainerEvent event) {
        Iterator i = this.containerListeners.iterator();
        while (i.hasNext()) {
            IContainerListener l = (IContainerListener)i.next();
            l.handleEvent(event);
        }
    }

    public Object getAdapter(Class serviceType) {
        IAdapterManager adapterManager = ECFPlugin.getDefault().getAdapterManager();
        if (adapterManager == null) {
            return null;
        }
        return adapterManager.getAdapter((Object)this, serviceType);
    }

    protected String getPasswordFromConnectContext(IConnectContext connectContext) throws ContainerConnectException {
        String pw = null;
        try {
            CallbackHandler handler;
            Callback[] callbacks = new Callback[]{new ObjectCallback()};
            if (connectContext != null && (handler = connectContext.getCallbackHandler()) != null) {
                handler.handle(callbacks);
            }
            ObjectCallback cb = (ObjectCallback)callbacks[0];
            pw = (String)cb.getObject();
        }
        catch (Exception e) {
            throw new ContainerConnectException(Messages.AbstractContainer_Exception_Callback_Handler, e);
        }
        return pw;
    }
}

