/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ecf.core;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.ecf.core.ContainerCreateException;
import org.eclipse.ecf.core.ContainerTypeDescription;
import org.eclipse.ecf.core.IContainer;
import org.eclipse.ecf.core.IContainerFactory;
import org.eclipse.ecf.core.IContainerManager;
import org.eclipse.ecf.core.identity.ID;
import org.eclipse.ecf.core.provider.IContainerInstantiator;
import org.eclipse.ecf.core.util.Trace;
import org.eclipse.ecf.internal.core.ECFPlugin;
import org.eclipse.ecf.internal.core.IDisposable;
import org.eclipse.ecf.internal.core.Messages;

public class ContainerFactory
implements IContainerFactory,
IContainerManager {
    public static final String BASE_CONTAINER_NAME = Messages.ContainerFactory_Base_Container_Name;
    private static Hashtable containerdescriptions = new Hashtable();
    private static IContainerFactory instance = null;
    private static Map containers = Collections.synchronizedMap(new HashMap());
    static /* synthetic */ Class class$0;

    static {
        instance = new ContainerFactory();
    }

    public static IContainerFactory getDefault() {
        return instance;
    }

    protected ContainerFactory() {
        ECFPlugin ecfplugin = ECFPlugin.getDefault();
        if (ecfplugin != null) {
            ecfplugin.addDisposable(new IDisposable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void dispose() {
                    Map map = containers;
                    synchronized (map) {
                        Iterator i = containers.keySet().iterator();
                        while (i.hasNext()) {
                            IContainer c = (IContainer)containers.get(i.next());
                            try {
                                c.dispose();
                            }
                            catch (Throwable e) {
                                ECFPlugin.getDefault().log((IStatus)new Status(4, ECFPlugin.getDefault().getBundle().getSymbolicName(), 4, "container dispose error", e));
                                Class<?> clazz = class$0;
                                if (clazz == null) {
                                    try {
                                        clazz = Class.forName("org.eclipse.ecf.core.ContainerFactory");
                                    }
                                    catch (ClassNotFoundException classNotFoundException) {
                                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                                    }
                                }
                                Trace.catching((String)"org.eclipse.ecf", (String)"org.eclipse.ecf/debug/exceptions/catching", (Class)clazz, (String)"doDispose", (Throwable)e);
                            }
                        }
                        containers.clear();
                    }
                }
            });
        }
    }

    public IContainer addContainer(IContainer container) {
        Assert.isNotNull((Object)container);
        ID containerID = container.getID();
        Assert.isNotNull((Object)containerID, (String)Messages.ContainerFactory_EXCEPTION_CONTAINER_ID_NOT_NULL);
        return containers.put(containerID, container);
    }

    public IContainer removeContainer(IContainer container) {
        Assert.isNotNull((Object)container);
        ID containerID = container.getID();
        if (containerID == null) {
            return null;
        }
        return (IContainer)containers.remove(containerID);
    }

    public ContainerTypeDescription addDescription(ContainerTypeDescription scd) {
        return this.addDescription0(scd);
    }

    public List getDescriptions() {
        return this.getDescriptions0();
    }

    protected List getDescriptions0() {
        return new ArrayList(containerdescriptions.values());
    }

    protected ContainerTypeDescription addDescription0(ContainerTypeDescription n) {
        if (n == null) {
            return null;
        }
        return containerdescriptions.put(n.getName(), n);
    }

    public boolean containsDescription(ContainerTypeDescription scd) {
        return this.containsDescription0(scd);
    }

    protected boolean containsDescription0(ContainerTypeDescription scd) {
        if (scd == null) {
            return false;
        }
        return containerdescriptions.containsKey(scd.getName());
    }

    protected ContainerTypeDescription getDescription0(ContainerTypeDescription scd) {
        if (scd == null) {
            return null;
        }
        return (ContainerTypeDescription)containerdescriptions.get(scd.getName());
    }

    protected ContainerTypeDescription getDescription0(String name) {
        if (name == null) {
            return null;
        }
        return (ContainerTypeDescription)containerdescriptions.get(name);
    }

    public ContainerTypeDescription getDescriptionByName(String name) {
        return this.getDescription0(name);
    }

    protected void throwContainerCreateException(String message, Throwable cause, String method) throws ContainerCreateException {
        ContainerCreateException except = cause == null ? new ContainerCreateException(message) : new ContainerCreateException(message, cause);
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.ecf.core.ContainerFactory");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        Trace.throwing((String)"org.eclipse.ecf", (String)"org.eclipse.ecf/debug/exceptions/throwing", (Class)clazz, (String)method, (Throwable)((Object)except));
        throw except;
    }

    public IContainer createContainer() throws ContainerCreateException {
        return this.createContainer(BASE_CONTAINER_NAME);
    }

    public IContainer createContainer(ContainerTypeDescription description, Object[] parameters) throws ContainerCreateException {
        Class<?> clazz;
        ID containerID;
        ContainerTypeDescription cd;
        String method = "createContainer";
        Class<?> clazz2 = class$0;
        if (clazz2 == null) {
            try {
                clazz2 = class$0 = Class.forName("org.eclipse.ecf.core.ContainerFactory");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        Trace.entering((String)"org.eclipse.ecf", (String)"org.eclipse.ecf/debug/methods/entering", clazz2, (String)method, (Object[])new Object[]{description, Trace.getArgumentsString((Object[])parameters)});
        if (description == null) {
            this.throwContainerCreateException(Messages.ContainerFactory_Exception_Create_Container, null, method);
        }
        if ((cd = this.getDescription0(description)) == null) {
            this.throwContainerCreateException("ContainerTypeDescription '" + description.getName() + "' not found", null, method);
        }
        IContainerInstantiator instantiator = null;
        try {
            instantiator = cd.getInstantiator();
        }
        catch (Exception e) {
            this.throwContainerCreateException("createContainer cannot get IContainerInstantiator for description : " + description, e, method);
        }
        IContainer container = instantiator.createInstance(description, parameters);
        if (container == null) {
            this.throwContainerCreateException("Instantiator returned null for '" + cd.getName() + "'", null, method);
        }
        if ((containerID = container.getID()) != null) {
            this.addContainer(container);
        }
        if ((clazz = class$0) == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.ecf.core.ContainerFactory");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        Trace.exiting((String)"org.eclipse.ecf", (String)"org.eclipse.ecf/debug/methods/exiting", (Class)clazz, (String)method, (Object)container);
        return container;
    }

    public IContainer createContainer(String descriptionName) throws ContainerCreateException {
        return this.createContainer(this.getDescriptionByName(descriptionName), null);
    }

    public IContainer createContainer(String descriptionName, Object[] parameters) throws ContainerCreateException {
        return this.createContainer(this.getDescriptionByName(descriptionName), parameters);
    }

    public ContainerTypeDescription removeDescription(ContainerTypeDescription scd) {
        return this.removeDescription0(scd);
    }

    protected ContainerTypeDescription removeDescription0(ContainerTypeDescription n) {
        if (n == null) {
            return null;
        }
        return (ContainerTypeDescription)containerdescriptions.remove(n.getName());
    }

    public ContainerTypeDescription[] getDescriptionsForContainerAdapter(Class containerAdapter) {
        if (containerAdapter == null) {
            throw new NullPointerException(Messages.ContainerFactory_Exception_Adapter_Not_Null);
        }
        ArrayList<ContainerTypeDescription> result = new ArrayList<ContainerTypeDescription>();
        List descriptions = this.getDescriptions();
        Iterator i = descriptions.iterator();
        while (i.hasNext()) {
            ContainerTypeDescription description = (ContainerTypeDescription)i.next();
            String[] supportedAdapters = description.getSupportedAdapterTypes();
            if (supportedAdapters == null) continue;
            int j = 0;
            while (j < supportedAdapters.length) {
                if (supportedAdapters[j].equals(containerAdapter.getName())) {
                    result.add(description);
                }
                ++j;
            }
        }
        return result.toArray(new ContainerTypeDescription[0]);
    }

    public IContainer[] getAllContainers() {
        ArrayList containersList = new ArrayList(containers.values());
        return containersList.toArray(new IContainer[0]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IContainer getContainer(ID containerID) {
        if (containerID == null) {
            return null;
        }
        Map map = containers;
        synchronized (map) {
            Iterator i = containers.keySet().iterator();
            while (i.hasNext()) {
                IContainer container = (IContainer)containers.get(containerID);
                if (container == null) continue;
                return container;
            }
        }
        return null;
    }

    public boolean hasContainer(ID containerID) {
        return containers.containsKey(containerID);
    }
}

