/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ecf.core.identity;

import java.io.Serializable;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IAdapterManager;
import org.eclipse.ecf.core.identity.BaseID;
import org.eclipse.ecf.core.identity.ID;
import org.eclipse.ecf.core.identity.IDCreateException;
import org.eclipse.ecf.internal.core.identity.Activator;
import org.eclipse.ecf.internal.core.identity.Messages;

public abstract class Namespace
implements Serializable,
IAdaptable {
    private static final long serialVersionUID = 3976740272094720312L;
    public static final String SCHEME_SEPARATOR = ":";
    private String name;
    private String description;
    private int hashCode;
    private boolean isInitialized = false;

    public Namespace() {
    }

    public final boolean initialize(String name, String desc) {
        Assert.isNotNull((Object)name, (String)Messages.Namespace_Namespace_Name_Not_Null);
        if (!this.isInitialized) {
            this.name = name;
            this.description = desc;
            this.hashCode = name.hashCode();
            this.isInitialized = true;
            return true;
        }
        return false;
    }

    public Namespace(String name, String desc) {
        this.initialize(name, desc);
    }

    public boolean equals(Object other) {
        if (!(other instanceof Namespace)) {
            return false;
        }
        return ((Namespace)other).name.equals(this.name);
    }

    public int hashCode() {
        return this.hashCode;
    }

    protected boolean testIDEquals(BaseID first, BaseID second) {
        Namespace sn = second.getNamespace();
        if (sn == null || !this.equals(sn)) {
            return false;
        }
        return first.namespaceEquals(second);
    }

    protected String getNameForID(BaseID id) {
        return id.namespaceGetName();
    }

    protected int getCompareToForObject(BaseID first, BaseID second) {
        return first.namespaceCompareTo(second);
    }

    protected int getHashCodeForID(BaseID id) {
        return id.namespaceHashCode();
    }

    protected String toExternalForm(BaseID id) {
        return id.namespaceToExternalForm();
    }

    public String getName() {
        return this.name;
    }

    public String getDescription() {
        return this.description;
    }

    public abstract ID createInstance(Object[] var1) throws IDCreateException;

    public abstract String getScheme();

    public String[] getSupportedSchemes() {
        return new String[0];
    }

    public Class[][] getSupportedParameterTypes() {
        return new Class[][]{new Class[0]};
    }

    public Object getAdapter(Class adapter) {
        if (adapter.isInstance(this)) {
            return this;
        }
        IAdapterManager manager = Activator.getDefault().getAdapterManager();
        if (manager == null) {
            return null;
        }
        return manager.loadAdapter((Object)this, adapter.getName());
    }

    public String toString() {
        StringBuffer b = new StringBuffer("Namespace[");
        b.append("name=").append(this.name).append(";");
        b.append("scheme=").append(this.getScheme()).append(";");
        b.append("description=").append("]");
        return b.toString();
    }
}

