/*
 * Decompiled with CFR 0.152.
 */
package fj.data;

import fj.Bottom;
import fj.Equal;
import fj.F;
import fj.F2;
import fj.F2Functions;
import fj.F3;
import fj.Function;
import fj.Hash;
import fj.Monoid;
import fj.Ord;
import fj.Ordering;
import fj.P;
import fj.P1;
import fj.P2;
import fj.Show;
import fj.Unit;
import fj.control.Trampoline;
import fj.data.Array;
import fj.data.Either;
import fj.data.List$$Lambda$1;
import fj.data.List$$Lambda$2;
import fj.data.List$$Lambda$3;
import fj.data.List$$Lambda$4;
import fj.data.List$$Lambda$5;
import fj.data.Option;
import fj.data.Stream;
import fj.data.TreeMap;
import fj.function.Booleans;
import fj.function.Effect1;
import java.util.AbstractCollection;
import java.util.Collection;
import java.util.Iterator;
import java.util.NoSuchElementException;

public abstract class List<A>
implements Iterable<A> {
    private List() {
    }

    @Override
    public final Iterator<A> iterator() {
        return this.toCollection().iterator();
    }

    public abstract A head();

    public abstract List<A> tail();

    public final int length() {
        return this.foldLeft(new F<Integer, F<A, Integer>>(){

            @Override
            public F<A, Integer> f(final Integer i) {
                return new F<A, Integer>(){

                    @Override
                    public Integer f(A a) {
                        return i + 1;
                    }
                };
            }
        }, Integer.valueOf(0));
    }

    public final boolean isEmpty() {
        return this instanceof Nil;
    }

    public final boolean isNotEmpty() {
        return this instanceof Cons;
    }

    public final <B> B list(B nil, F<A, F<List<A>, B>> cons) {
        return this.isEmpty() ? nil : cons.f(this.head()).f(this.tail());
    }

    public final A orHead(P1<A> a) {
        return this.isEmpty() ? a._1() : this.head();
    }

    public final List<A> orTail(P1<List<A>> as) {
        return this.isEmpty() ? as._1() : this.tail();
    }

    public final Option<A> toOption() {
        return this.isEmpty() ? Option.none() : Option.some(this.head());
    }

    public final <X> Either<X, A> toEither(P1<X> x) {
        return this.isEmpty() ? Either.left(x._1()) : Either.right(this.head());
    }

    public final Stream<A> toStream() {
        Stream nil = Stream.nil();
        return this.foldRight(new F<A, F<Stream<A>, Stream<A>>>(){

            @Override
            public F<Stream<A>, Stream<A>> f(final A a) {
                return new F<Stream<A>, Stream<A>>(){

                    @Override
                    public Stream<A> f(Stream<A> as) {
                        return as.cons(a);
                    }
                };
            }
        }, nil);
    }

    public final Array<A> toArray() {
        Object[] a = new Object[this.length()];
        List<A> x = this;
        for (int i = 0; i < this.length(); ++i) {
            a[i] = x.head();
            x = x.tail();
        }
        return Array.mkArray(a);
    }

    public final Array<A> toArray(Class<A[]> c) {
        Object[] a = (Object[])java.lang.reflect.Array.newInstance(c.getComponentType(), this.length());
        List<A> x = this;
        for (int i = 0; i < this.length(); ++i) {
            a[i] = x.head();
            x = x.tail();
        }
        return Array.array(a);
    }

    public final A[] array(Class<A[]> c) {
        return this.toArray(c).array(c);
    }

    public final List<A> cons(A a) {
        return new Cons<A>(a, this);
    }

    public final List<A> conss(A a) {
        return new Cons<A>(a, this);
    }

    public final <B> List<B> map(F<A, B> f) {
        Buffer<B> bs = Buffer.empty();
        List<A> xs = this;
        while (xs.isNotEmpty()) {
            bs.snoc(f.f(xs.head()));
            xs = xs.tail();
        }
        return bs.toList();
    }

    public final Unit foreach(F<A, Unit> f) {
        List<A> xs = this;
        while (xs.isNotEmpty()) {
            f.f(xs.head());
            xs = xs.tail();
        }
        return Unit.unit();
    }

    public final void foreachDoEffect(Effect1<A> f) {
        List<A> xs = this;
        while (xs.isNotEmpty()) {
            f.f(xs.head());
            xs = xs.tail();
        }
    }

    public final List<A> filter(F<A, Boolean> f) {
        Buffer<A> b = Buffer.empty();
        List<A> xs = this;
        while (xs.isNotEmpty()) {
            A h = xs.head();
            if (f.f(h).booleanValue()) {
                b.snoc(h);
            }
            xs = xs.tail();
        }
        return b.toList();
    }

    public final List<A> removeAll(F<A, Boolean> f) {
        return this.filter(Function.compose(Booleans.not, f));
    }

    public final List<A> delete(A a, Equal<A> e) {
        P2<List<A>, List<A>> p = this.span(Function.compose(Booleans.not, e.eq(a)));
        return p._2().isEmpty() ? p._1() : p._1().append(p._2().tail());
    }

    public final List<A> takeWhile(F<A, Boolean> f) {
        Buffer<A> b = Buffer.empty();
        boolean taking = true;
        List<A> xs = this;
        while (xs.isNotEmpty() && taking) {
            A h = xs.head();
            if (f.f(h).booleanValue()) {
                b.snoc(h);
            } else {
                taking = false;
            }
            xs = xs.tail();
        }
        return b.toList();
    }

    public final List<A> dropWhile(F<A, Boolean> f) {
        List<A> xs = this;
        while (xs.isNotEmpty() && f.f(xs.head()).booleanValue()) {
            xs = xs.tail();
        }
        return xs;
    }

    public final P2<List<A>, List<A>> span(F<A, Boolean> p) {
        Buffer<A> b = Buffer.empty();
        List<A> xs = this;
        while (xs.isNotEmpty()) {
            if (!p.f(xs.head()).booleanValue()) {
                return P.p(b.toList(), xs);
            }
            b.snoc(xs.head());
            xs = xs.tail();
        }
        return P.p(b.toList(), List.nil());
    }

    public final P2<List<A>, List<A>> breakk(final F<A, Boolean> p) {
        return this.span(new F<A, Boolean>(){

            @Override
            public Boolean f(A a) {
                return (Boolean)p.f(a) == false;
            }
        });
    }

    public final List<List<A>> group(Equal<A> e) {
        if (this.isEmpty()) {
            return List.nil();
        }
        P2<List<A>, List<A>> z = this.tail().span(e.eq(this.head()));
        return List.cons(z._1().cons(this.head()), z._2().group(e));
    }

    public final <B> List<B> bind(F<A, List<B>> f) {
        Buffer<B> b = Buffer.empty();
        List<A> xs = this;
        while (xs.isNotEmpty()) {
            b.append(f.f(xs.head()));
            xs = xs.tail();
        }
        return b.toList();
    }

    public final <B, C> List<C> bind(List<B> lb, F<A, F<B, C>> f) {
        return lb.apply(this.map(f));
    }

    public final <B, C> List<C> bind(List<B> lb, F2<A, B, C> f) {
        return this.bind(lb, Function.curry(f));
    }

    public static <A, B, C> F<List<A>, F<List<B>, List<C>>> liftM2(final F<A, F<B, C>> f) {
        return Function.curry(new F2<List<A>, List<B>, List<C>>(){

            @Override
            public List<C> f(List<A> as, List<B> bs) {
                return as.bind(bs, f);
            }
        });
    }

    public final <B, C, D> List<D> bind(List<B> lb, List<C> lc, F<A, F<B, F<C, D>>> f) {
        return lc.apply(this.bind(lb, f));
    }

    public final <B, C, D, E> List<E> bind(List<B> lb, List<C> lc, List<D> ld, F<A, F<B, F<C, F<D, E>>>> f) {
        return ld.apply(this.bind(lb, lc, f));
    }

    public final <B, C, D, E, F$> List<F$> bind(List<B> lb, List<C> lc, List<D> ld, List<E> le, F<A, F<B, F<C, F<D, F<E, F$>>>>> f) {
        return le.apply(this.bind(lb, lc, ld, f));
    }

    public final <B, C, D, E, F$, G> List<G> bind(List<B> lb, List<C> lc, List<D> ld, List<E> le, List<F$> lf, F<A, F<B, F<C, F<D, F<E, F<F$, G>>>>>> f) {
        return lf.apply(this.bind(lb, lc, ld, le, f));
    }

    public final <B, C, D, E, F$, G, H> List<H> bind(List<B> lb, List<C> lc, List<D> ld, List<E> le, List<F$> lf, List<G> lg, F<A, F<B, F<C, F<D, F<E, F<F$, F<G, H>>>>>>> f) {
        return lg.apply(this.bind(lb, lc, ld, le, lf, f));
    }

    public final <B, C, D, E, F$, G, H, I> List<I> bind(List<B> lb, List<C> lc, List<D> ld, List<E> le, List<F$> lf, List<G> lg, List<H> lh, F<A, F<B, F<C, F<D, F<E, F<F$, F<G, F<H, I>>>>>>>> f) {
        return lh.apply(this.bind(lb, lc, ld, le, lf, lg, f));
    }

    public final <B> List<B> sequence(List<B> bs) {
        F c = Function.constant(bs);
        return this.bind(c);
    }

    public final <B> List<B> apply(List<F<A, B>> lf) {
        return lf.bind(new F<F<A, B>, List<B>>(){

            @Override
            public List<B> f(F<A, B> f) {
                return List.this.map(f);
            }
        });
    }

    public final List<A> append(List<A> as) {
        return Buffer.fromList(this).append(as).toList();
    }

    public final <B> B foldRight(F<A, F<B, B>> f, B b) {
        return this.isEmpty() ? b : f.f(this.head()).f(this.tail().foldRight(f, b));
    }

    public final <B> B foldRight(F2<A, B, B> f, B b) {
        return this.foldRight(Function.curry(f), b);
    }

    public final <B> Trampoline<B> foldRightC(final F2<A, B, B> f, final B b) {
        return Trampoline.suspend(new P1<Trampoline<B>>(){

            @Override
            public Trampoline<B> _1() {
                return List.this.isEmpty() ? Trampoline.pure(b) : List.this.tail().foldRightC(f, b).map(F2Functions.f(f, List.this.head()));
            }
        });
    }

    public final <B> B foldLeft(F<B, F<A, B>> f, B b) {
        B x = b;
        List<A> xs = this;
        while (!xs.isEmpty()) {
            x = f.f(x).f(xs.head());
            xs = xs.tail();
        }
        return x;
    }

    public final <B> B foldLeft(F2<B, A, B> f, B b) {
        return this.foldLeft(Function.curry(f), b);
    }

    public final A foldLeft1(F2<A, A, A> f) {
        return this.foldLeft1(Function.curry(f));
    }

    public final A foldLeft1(F<A, F<A, A>> f) {
        if (this.isEmpty()) {
            throw Bottom.error("Undefined: foldLeft1 on empty list");
        }
        return this.tail().foldLeft(f, this.head());
    }

    public final List<A> reverse() {
        return this.foldLeft(new F<List<A>, F<A, List<A>>>(){

            @Override
            public F<A, List<A>> f(final List<A> as) {
                return new F<A, List<A>>(){

                    @Override
                    public List<A> f(A a) {
                        return List.cons(a, as);
                    }
                };
            }
        }, List.nil());
    }

    public final A index(int i) {
        if (i < 0 || i > this.length() - 1) {
            throw Bottom.error("index " + i + " out of range on list with length " + this.length());
        }
        List<A> xs = this;
        for (int c = 0; c < i; ++c) {
            xs = xs.tail();
        }
        return xs.head();
    }

    public final List<A> take(int i) {
        return i <= 0 || this.isEmpty() ? List.nil() : List.cons(this.head(), this.tail().take(i - 1));
    }

    public final List<A> drop(int i) {
        int c = 0;
        List<A> xs = this;
        while (xs.isNotEmpty() && c < i) {
            ++c;
            xs = xs.tail();
        }
        return xs;
    }

    public final P2<List<A>, List<A>> splitAt(int i) {
        P2<List<Object>, List<Object>> s = P.p(List.nil(), List.nil());
        int c = 0;
        List<A> xs = this;
        while (xs.isNotEmpty()) {
            final A h = xs.head();
            s = c < i ? s.map1(new F<List<A>, List<A>>(){

                @Override
                public List<A> f(List<A> as) {
                    return as.snoc(h);
                }
            }) : s.map2(new F<List<A>, List<A>>(){

                @Override
                public List<A> f(List<A> as) {
                    return as.snoc(h);
                }
            });
            ++c;
            xs = xs.tail();
        }
        return s;
    }

    public final List<List<A>> partition(final int n) {
        if (n < 1) {
            throw Bottom.error("Can't create list partitions shorter than 1 element long.");
        }
        if (this.isEmpty()) {
            throw Bottom.error("Partition on empty list.");
        }
        return List.unfold(new F<List<A>, Option<P2<List<A>, List<A>>>>(){

            @Override
            public Option<P2<List<A>, List<A>>> f(List<A> as) {
                return as.isEmpty() ? Option.none() : Option.some(as.splitAt(n));
            }
        }, this);
    }

    public final List<List<A>> inits() {
        List<List<List<A>>> s = List.single(List.nil());
        if (this.isNotEmpty()) {
            s = s.append(this.tail().inits().map(List.cons().f(this.head())));
        }
        return s;
    }

    public final List<List<A>> tails() {
        return this.isEmpty() ? List.single(List.nil()) : List.cons(this, this.tail().tails());
    }

    public final List<A> sort(Ord<A> o) {
        if (this.isEmpty()) {
            return List.nil();
        }
        if (this.tail().isEmpty()) {
            return this;
        }
        P2<List<A>, List<A>> s = this.splitAt(this.length() / 2);
        final class Merge<A> {
            Merge() {
            }

            List<A> merge(List<A> xs, List<A> ys, Ord<A> o) {
                Buffer<A> buf = Buffer.empty();
                while (true) {
                    A y;
                    if (xs.isEmpty()) {
                        buf.append(ys);
                        break;
                    }
                    if (ys.isEmpty()) {
                        buf.append(xs);
                        break;
                    }
                    A x = xs.head();
                    if (o.isLessThan(x, y = ys.head())) {
                        buf.snoc(x);
                        xs = xs.tail();
                        continue;
                    }
                    buf.snoc(y);
                    ys = ys.tail();
                }
                return buf.toList();
            }
        }
        return new Merge<A>().merge(s._1().sort(o), s._2().sort(o), o);
    }

    public final <B, C> List<C> zipWith(List<B> bs, F<A, F<B, C>> f) {
        Buffer<C> buf = Buffer.empty();
        List<A> as = this;
        while (as.isNotEmpty() && bs.isNotEmpty()) {
            buf.snoc(f.f(as.head()).f(bs.head()));
            as = as.tail();
            bs = bs.tail();
        }
        return buf.toList();
    }

    public final <B, C> List<C> zipWith(List<B> bs, F2<A, B, C> f) {
        return this.zipWith(bs, Function.curry(f));
    }

    public static <A, B, C> F<List<A>, F<List<B>, F<F<A, F<B, C>>, List<C>>>> zipWith() {
        return Function.curry(new F3<List<A>, List<B>, F<A, F<B, C>>, List<C>>(){

            @Override
            public List<C> f(List<A> as, List<B> bs, F<A, F<B, C>> f) {
                return as.zipWith(bs, f);
            }
        });
    }

    public final <B> List<P2<A, B>> zip(List<B> bs) {
        F __2 = P.p2();
        return this.zipWith(bs, __2);
    }

    public static <A, B> F<List<A>, F<List<B>, List<P2<A, B>>>> zip() {
        return Function.curry(new F2<List<A>, List<B>, List<P2<A, B>>>(){

            @Override
            public List<P2<A, B>> f(List<A> as, List<B> bs) {
                return as.zip(bs);
            }
        });
    }

    public final List<P2<A, Integer>> zipIndex() {
        return this.zipWith(List.range(0, this.length()), new F<A, F<Integer, P2<A, Integer>>>(){

            @Override
            public F<Integer, P2<A, Integer>> f(final A a) {
                return new F<Integer, P2<A, Integer>>(){

                    @Override
                    public P2<A, Integer> f(Integer i) {
                        return P.p(a, i);
                    }
                };
            }
        });
    }

    public final List<A> snoc(A a) {
        return Buffer.fromList(this).snoc(a).toList();
    }

    public final boolean forall(F<A, Boolean> f) {
        return this.isEmpty() || f.f(this.head()) != false && this.tail().forall(f);
    }

    public final boolean exists(F<A, Boolean> f) {
        return this.find(f).isSome();
    }

    public final Option<A> find(F<A, Boolean> f) {
        List<A> as = this;
        while (as.isNotEmpty()) {
            if (f.f(as.head()).booleanValue()) {
                return Option.some(as.head());
            }
            as = as.tail();
        }
        return Option.none();
    }

    public final List<A> intersperse(A a) {
        return this.isEmpty() || this.tail().isEmpty() ? this : List.cons(this.head(), List.cons(a, this.tail().intersperse(a)));
    }

    public final List<A> intercalate(List<List<A>> as) {
        return List.join(as.intersperse(this));
    }

    public final List<A> nub() {
        return this.nub(Equal.anyEqual());
    }

    public final List<A> nub(final Equal<A> eq) {
        return this.isEmpty() ? this : List.cons(this.head(), this.tail().filter(new F<A, Boolean>(){

            @Override
            public Boolean f(A a) {
                return !eq.eq(a, List.this.head());
            }
        }).nub(eq));
    }

    public final List<A> nub(Ord<A> o) {
        return this.sort(o).group(o.equal()).map(List.head_());
    }

    public static <A> F<List<A>, A> head_() {
        return new F<List<A>, A>(){

            @Override
            public A f(List<A> list) {
                return list.head();
            }
        };
    }

    public static <A> F<List<A>, List<A>> tail_() {
        return new F<List<A>, List<A>>(){

            @Override
            public List<A> f(List<A> list) {
                return list.tail();
            }
        };
    }

    public final List<A> minus(Equal<A> eq, List<A> xs) {
        return this.removeAll(Function.compose(Monoid.disjunctionMonoid.sumLeft(), xs.mapM(Function.curry(eq.eq()))));
    }

    public final <B, C> F<B, List<C>> mapM(F<A, F<B, C>> f) {
        return List.sequence_(this.map(f));
    }

    public final <B> Option<List<B>> mapMOption(final F<A, Option<B>> f) {
        return this.foldRight(new F2<A, Option<List<B>>, Option<List<B>>>(){

            @Override
            public Option<List<B>> f(A a, final Option<List<B>> bs) {
                return ((Option)f.f(a)).bind(new F<B, Option<List<B>>>(){

                    @Override
                    public Option<List<B>> f(final B b) {
                        return bs.map(new F<List<B>, List<B>>(){

                            @Override
                            public List<B> f(List<B> bbs) {
                                return bbs.cons(b);
                            }
                        });
                    }
                });
            }
        }, Option.some(List.nil()));
    }

    public final <B> Trampoline<List<B>> mapMTrampoline(final F<A, Trampoline<B>> f) {
        return this.foldRight(new F2<A, Trampoline<List<B>>, Trampoline<List<B>>>(){

            @Override
            public Trampoline<List<B>> f(A a, final Trampoline<List<B>> bs) {
                return ((Trampoline)f.f(a)).bind(new F<B, Trampoline<List<B>>>(){

                    @Override
                    public Trampoline<List<B>> f(final B b) {
                        return bs.map(new F<List<B>, List<B>>(){

                            @Override
                            public List<B> f(List<B> bbs) {
                                return bbs.cons(b);
                            }
                        });
                    }
                });
            }
        }, Trampoline.pure(List.nil()));
    }

    public final Option<Integer> elementIndex(Equal<A> e, A a) {
        return List.lookup(e, this.zipIndex(), a);
    }

    public final A last() {
        A a = this.head();
        List<A> xs = this.tail();
        while (xs.isNotEmpty()) {
            a = xs.head();
            xs = xs.tail();
        }
        return a;
    }

    public final List<A> init() {
        List<A> ys = this;
        Buffer<A> a = Buffer.empty();
        while (ys.isNotEmpty() && ys.tail().isNotEmpty()) {
            a.snoc(this.head());
            ys = ys.tail();
        }
        return a.toList();
    }

    public final List<A> insertBy(F<A, F<A, Ordering>> f, A x) {
        List<A> ys = this;
        Buffer<A> xs = Buffer.empty();
        while (ys.isNotEmpty() && f.f(x).f(ys.head()) == Ordering.GT) {
            xs = xs.snoc(ys.head());
            ys = ys.tail();
        }
        return xs.append(ys.cons(x)).toList();
    }

    public final A mode(Ord<A> o) {
        return this.sort(o).group(o.equal()).maximum(Ord.intOrd.comap(List.length_())).head();
    }

    public final <B> TreeMap<B, List<A>> groupBy(F<A, B> keyFunction) {
        return this.groupBy(keyFunction, Ord.hashOrd());
    }

    public final <B> TreeMap<B, List<A>> groupBy(F<A, B> keyFunction, Ord<B> keyOrd) {
        return this.groupBy(keyFunction, Function.identity(), keyOrd);
    }

    public final <B, C> TreeMap<B, List<C>> groupBy(F<A, B> keyFunction, F<A, C> valueFunction) {
        return this.groupBy(keyFunction, valueFunction, Ord.hashOrd());
    }

    public final <B, C> TreeMap<B, List<C>> groupBy(F<A, B> keyFunction, F<A, C> valueFunction, Ord<B> keyOrd) {
        return this.groupBy(keyFunction, valueFunction, List.nil(), List$$Lambda$1.lambdaFactory$(), keyOrd);
    }

    public final <B, C> TreeMap<B, C> groupBy(F<A, B> keyFunction, F<A, C> valueFunction, Monoid<C> monoid, Ord<B> keyOrd) {
        return this.groupBy(keyFunction, valueFunction, monoid.zero(), Function.uncurryF2(monoid.sum()), keyOrd);
    }

    public final <B, C, D> TreeMap<B, D> groupBy(F<A, B> keyFunction, F<A, C> valueFunction, D groupingIdentity, F2<C, D, D> groupingAcc, Ord<B> keyOrd) {
        return this.foldLeft(List$$Lambda$2.lambdaFactory$(keyFunction, valueFunction, groupingAcc, groupingIdentity), TreeMap.empty(keyOrd));
    }

    public boolean allEqual(Equal<A> eq) {
        return this.isEmpty() || this.tail().isEmpty() || eq.eq(this.head(), this.tail().head()) && this.tail().allEqual(eq);
    }

    public static <A> F<List<A>, Integer> length_() {
        return new F<List<A>, Integer>(){

            @Override
            public Integer f(List<A> a) {
                return a.length();
            }
        };
    }

    public final A maximum(Ord<A> o) {
        return this.foldLeft1(o.max);
    }

    public final A minimum(Ord<A> o) {
        return this.foldLeft1(o.min);
    }

    public final Collection<A> toCollection() {
        return new AbstractCollection<A>(){

            @Override
            public Iterator<A> iterator() {
                return new Iterator<A>(){
                    private List<A> xs;
                    {
                        this.xs = List.this;
                    }

                    @Override
                    public boolean hasNext() {
                        return this.xs.isNotEmpty();
                    }

                    @Override
                    public A next() {
                        if (this.xs.isEmpty()) {
                            throw new NoSuchElementException();
                        }
                        Object a = this.xs.head();
                        this.xs = this.xs.tail();
                        return a;
                    }

                    @Override
                    public void remove() {
                        throw new UnsupportedOperationException();
                    }
                };
            }

            @Override
            public int size() {
                return List.this.length();
            }
        };
    }

    public static <A> List<A> list(A ... as) {
        return Array.array(as).toList();
    }

    public static <A> List<A> nil() {
        return new Nil();
    }

    public static <A> F<A, F<List<A>, List<A>>> cons() {
        return new F<A, F<List<A>, List<A>>>(){

            @Override
            public F<List<A>, List<A>> f(final A a) {
                return new F<List<A>, List<A>>(){

                    @Override
                    public List<A> f(List<A> tail) {
                        return List.cons(a, tail);
                    }
                };
            }
        };
    }

    public static <A> F2<A, List<A>, List<A>> cons_() {
        return List$$Lambda$3.lambdaFactory$();
    }

    public static <A> F<A, List<A>> cons(final List<A> tail) {
        return new F<A, List<A>>(){

            @Override
            public List<A> f(A a) {
                return tail.cons(a);
            }
        };
    }

    public static <A> F<List<A>, List<A>> cons_(final A a) {
        return new F<List<A>, List<A>>(){

            @Override
            public List<A> f(List<A> as) {
                return as.cons(a);
            }
        };
    }

    public static <A> List<A> cons(A head, List<A> tail) {
        return new Cons<A>(head, tail);
    }

    public static <A> F<List<A>, Boolean> isEmpty_() {
        return new F<List<A>, Boolean>(){

            @Override
            public Boolean f(List<A> as) {
                return as.isEmpty();
            }
        };
    }

    public static <A> F<List<A>, Boolean> isNotEmpty_() {
        return new F<List<A>, Boolean>(){

            @Override
            public Boolean f(List<A> as) {
                return as.isNotEmpty();
            }
        };
    }

    public static <A> List<A> join(List<List<A>> o) {
        F id = Function.identity();
        return o.bind(id);
    }

    public static <A> F<List<List<A>>, List<A>> join() {
        return new F<List<List<A>>, List<A>>(){

            @Override
            public List<A> f(List<List<A>> as) {
                return List.join(as);
            }
        };
    }

    public static <A, B> List<A> unfold(F<B, Option<P2<A, B>>> f, B b) {
        Buffer<A> buf = Buffer.empty();
        Option<P2<A, B>> o = f.f(b);
        while (o.isSome()) {
            buf = buf.snoc(o.some()._1());
            o = f.f(o.some()._2());
        }
        return buf.toList();
    }

    public static <A, B> P2<List<A>, List<B>> unzip(List<P2<A, B>> xs) {
        Buffer<A> ba = Buffer.empty();
        Buffer<B> bb = Buffer.empty();
        for (P2<A, B> p : xs) {
            ba = ba.snoc(p._1());
            bb = bb.snoc(p._2());
        }
        return P.p(ba.toList(), bb.toList());
    }

    public static <A> List<A> replicate(int n, A a) {
        return n <= 0 ? List.nil() : List.replicate(n - 1, a).cons(a);
    }

    public static List<Integer> range(int from, int to) {
        return from >= to ? List.nil() : List.cons(from, List.range(from + 1, to));
    }

    public static List<Character> fromString(String s) {
        List<Character> cs = List.nil();
        for (int i = s.length() - 1; i >= 0; --i) {
            cs = List.cons(Character.valueOf(s.charAt(i)), cs);
        }
        return cs;
    }

    public static F<String, List<Character>> fromString() {
        return new F<String, List<Character>>(){

            @Override
            public List<Character> f(String s) {
                return List.fromString(s);
            }
        };
    }

    public static String asString(List<Character> cs) {
        final StringBuilder sb = new StringBuilder();
        cs.foreach(new F<Character, Unit>(){

            @Override
            public Unit f(Character c) {
                sb.append(c);
                return Unit.unit();
            }
        });
        return sb.toString();
    }

    public static F<List<Character>, String> asString() {
        return new F<List<Character>, String>(){

            @Override
            public String f(List<Character> cs) {
                return List.asString(cs);
            }
        };
    }

    public static <A> List<A> single(A a) {
        return List.cons(a, List.nil());
    }

    public static <A> List<A> iterateWhile(final F<A, A> f, final F<A, Boolean> p, A a) {
        return List.unfold(new F<A, Option<P2<A, A>>>(){

            @Override
            public Option<P2<A, A>> f(final A o) {
                return Option.iif(new F<P2<A, A>, Boolean>(){

                    @Override
                    public Boolean f(P2<A, A> p2) {
                        return (Boolean)p.f(o);
                    }
                }, P.p(o, f.f(o)));
            }
        }, a);
    }

    public static <A, B> Option<B> lookup(final Equal<A> e, List<P2<A, B>> x, final A a) {
        return x.find(new F<P2<A, B>, Boolean>(){

            @Override
            public Boolean f(P2<A, B> p) {
                return e.eq(p._1(), a);
            }
        }).map(P2.__2());
    }

    public static <A, B> F2<List<P2<A, B>>, A, Option<B>> lookup(final Equal<A> e) {
        return new F2<List<P2<A, B>>, A, Option<B>>(){

            @Override
            public Option<B> f(List<P2<A, B>> x, A a) {
                return List.lookup(e, x, a);
            }
        };
    }

    public static <A, B> F<F<A, List<B>>, F<List<A>, List<B>>> bind_() {
        return Function.curry(new F2<F<A, List<B>>, List<A>, List<B>>(){

            @Override
            public List<B> f(F<A, List<B>> f, List<A> as) {
                return as.bind(f);
            }
        });
    }

    public static <A, B> F<F<A, B>, F<List<A>, List<B>>> map_() {
        return Function.curry(new F2<F<A, B>, List<A>, List<B>>(){

            @Override
            public List<B> f(F<A, B> f, List<A> as) {
                return as.map(f);
            }
        });
    }

    public static <A, B> F<B, List<A>> sequence_(List<F<B, A>> fs) {
        return fs.foldRight(Function.lift(List.cons()), Function.constant(List.nil()));
    }

    public static <A, B> F<F<B, F<A, B>>, F<B, F<List<A>, B>>> foldLeft() {
        return Function.curry(new F3<F<B, F<A, B>>, B, List<A>, B>(){

            @Override
            public B f(F<B, F<A, B>> f, B b, List<A> as) {
                return as.foldLeft(f, b);
            }
        });
    }

    public static <A> F<Integer, F<List<A>, List<A>>> take() {
        return Function.curry(new F2<Integer, List<A>, List<A>>(){

            @Override
            public List<A> f(Integer n, List<A> as) {
                return as.take(n);
            }
        });
    }

    public static <A> List<A> iterableList(Iterable<A> i) {
        Buffer<A> bs = Buffer.empty();
        for (A a : i) {
            bs.snoc(a);
        }
        return bs.toList();
    }

    public boolean equals(Object obj) {
        if (obj == null || !(obj instanceof List)) {
            return false;
        }
        return Equal.listEqual(Equal.anyEqual()).eq(this, (List)obj);
    }

    public int hashCode() {
        return Hash.listHash(Hash.anyHash()).hash(this);
    }

    public String toString() {
        return Show.listShow(Show.anyShow()).show(this).foldLeft(new F2<String, Character, String>(){

            @Override
            public String f(String s, Character c) {
                return s + c;
            }
        }, "");
    }

    private static /* synthetic */ F lambda$groupBy$37(F f, F f2, F2 f22, Object object, TreeMap map) {
        return List$$Lambda$4.lambdaFactory$(f, f2, map, f22, object);
    }

    private static /* synthetic */ TreeMap lambda$null$36(F f, F f2, TreeMap treeMap, F2 f22, Object object, Object element) {
        Object key = f.f(element);
        Object value = f2.f(element);
        return treeMap.set(key, treeMap.get(key).map(List$$Lambda$5.lambdaFactory$(f22, value)).orSome(f22.f(value, object)));
    }

    static /* synthetic */ List access$lambda$0(Object object, List list) {
        return List.cons(object, list);
    }

    static /* synthetic */ F access$lambda$1(F f, F f2, F2 f22, Object object, TreeMap treeMap) {
        return List.lambda$groupBy$37(f, f2, f22, object, treeMap);
    }

    static /* synthetic */ List access$lambda$2(Object object, List list) {
        return List.cons(object, list);
    }

    static /* synthetic */ TreeMap access$lambda$3(F f, F f2, TreeMap treeMap, F2 f22, Object object, Object object2) {
        return List.lambda$null$36(f, f2, treeMap, f22, object, object2);
    }

    static /* synthetic */ Object access$lambda$4(F2 f2, Object object, Object object2) {
        return f2.f(object, object2);
    }

    public static final class Buffer<A>
    implements Iterable<A> {
        private List<A> start = List.nil();
        private Cons<A> tail;
        private boolean exported;

        @Override
        public Iterator<A> iterator() {
            return this.start.iterator();
        }

        public Buffer<A> snoc(A a) {
            if (this.exported) {
                this.copy();
            }
            Cons<A> t = new Cons<A>(a, List.nil());
            if (this.tail == null) {
                this.start = t;
            } else {
                ((Cons)this.tail).tail(t);
            }
            this.tail = t;
            return this;
        }

        public Buffer<A> append(List<A> as) {
            List<A> xs = as;
            while (xs.isNotEmpty()) {
                this.snoc(xs.head());
                xs = xs.tail();
            }
            return this;
        }

        public List<A> toList() {
            this.exported = !this.start.isEmpty();
            return this.start;
        }

        public Collection<A> toCollection() {
            return this.start.toCollection();
        }

        public static <A> Buffer<A> empty() {
            return new Buffer<A>();
        }

        public static <A> Buffer<A> fromList(List<A> as) {
            Buffer<A> b = new Buffer<A>();
            List<A> xs = as;
            while (xs.isNotEmpty()) {
                b.snoc(xs.head());
                xs = xs.tail();
            }
            return b;
        }

        public static <A> Buffer<A> iterableBuffer(Iterable<A> i) {
            Buffer<A> b = Buffer.empty();
            for (A a : i) {
                b.snoc(a);
            }
            return b;
        }

        private void copy() {
            Cons<A> t = this.tail;
            this.start = List.nil();
            this.exported = false;
            for (List<A> s = this.start; s != t; s = s.tail()) {
                this.snoc(s.head());
            }
            if (t != null) {
                this.snoc(t.head());
            }
        }
    }

    private static final class Cons<A>
    extends List<A> {
        private final A head;
        private List<A> tail;

        Cons(A head, List<A> tail) {
            this.head = head;
            this.tail = tail;
        }

        @Override
        public A head() {
            return this.head;
        }

        @Override
        public List<A> tail() {
            return this.tail;
        }

        private void tail(List<A> tail) {
            this.tail = tail;
        }
    }

    private static final class Nil<A>
    extends List<A> {
        private Nil() {
        }

        @Override
        public A head() {
            throw Bottom.error("head on empty list");
        }

        @Override
        public List<A> tail() {
            throw Bottom.error("tail on empty list");
        }
    }
}

