/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emt4j.agent.common;

import java.io.File;
import java.io.IOException;
import java.security.ProtectionDomain;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.Locale;
import java.util.Optional;
import org.eclipse.emt4j.agent.common.AgentOption;
import org.eclipse.emt4j.agent.common.DependencyBuilder;
import org.eclipse.emt4j.agent.common.JdkDependConfig;
import org.eclipse.emt4j.agent.common.LoadedJarRecorder;
import org.eclipse.emt4j.agent.common.SystemClassLoaderIReference;
import org.eclipse.emt4j.agent.common.file.BinaryFileWriter;
import org.eclipse.emt4j.agent.common.file.Recorder;
import org.eclipse.emt4j.agent.common.file.ReportRecorder;
import org.eclipse.emt4j.agent.common.jdkdependent.CallerProvider;
import org.eclipse.emt4j.agent.common.jdkdependent.GuessCallerInfo;
import org.eclipse.emt4j.common.CheckConfig;
import org.eclipse.emt4j.common.DependTarget;
import org.eclipse.emt4j.common.DependType;
import org.eclipse.emt4j.common.Dependency;
import org.eclipse.emt4j.common.Feature;
import org.eclipse.emt4j.common.classanalyze.ClassInspectorInstance;
import org.eclipse.emt4j.common.rule.InstanceRuleManager;
import org.eclipse.emt4j.common.util.ClassURL;

public class AgentFacade {
    private static Recorder recorder;
    private static LoadedJarRecorder loadedJarRecorder;
    private static AgentOption agentOption;
    private static CallerProvider callerProvider;
    private static final int GUESS_CALLER_NUM = 3;

    static synchronized void init(String args, JdkDependConfig jdkDependConfig) throws IOException, IllegalAccessException, InstantiationException, ClassNotFoundException {
        AgentFacade.parseArgs(args, jdkDependConfig.getFromVersion());
        AgentFacade.initCallerProvider(jdkDependConfig.getCallerProviderClassName());
        AgentFacade.initInstanceRules(jdkDependConfig.getRuleClasses());
        CheckConfig checkConfig = new CheckConfig();
        checkConfig.setCheckMode(Feature.DEFAULT);
        checkConfig.setFromVersion(agentOption.getFromVersion());
        checkConfig.setToVersion(agentOption.getToVersion());
        checkConfig.setPriority(agentOption.getPriority());
        ArrayList<String> features = new ArrayList<String>();
        features.add(Feature.DEFAULT.getId());
        recorder = new ReportRecorder(new BinaryFileWriter(AgentFacade.getOutputFile(), agentOption.getFromVersion(), agentOption.getToVersion(), features));
        recorder.init();
        loadedJarRecorder = new LoadedJarRecorder(recorder);
        SystemClassLoaderIReference.init();
        ClassURL.registerUrlProtocolHandler();
    }

    private static void initCallerProvider(String callerProviderClassName) throws ClassNotFoundException, IllegalAccessException, InstantiationException {
        callerProvider = (CallerProvider)Class.forName(callerProviderClassName).newInstance();
    }

    private static void initInstanceRules(String[] classList) {
        InstanceRuleManager.init(classList, new String[]{"default"}, new String[]{"agent"}, agentOption.getFromVersion(), agentOption.getToVersion(), agentOption.getPriority());
    }

    private static void parseArgs(String args, int fromVersion) {
        String[] paramArray;
        agentOption = new AgentOption();
        agentOption.setFromVersion(fromVersion);
        if (args != null && !"".equals(args) && (paramArray = args.split(",")) != null && paramArray.length > 0) {
            block12: for (String param : paramArray) {
                String[] kv = param.split("=");
                if (kv == null || kv.length != 2) {
                    throw new RuntimeException("Illegal agent parameters for : [" + param + "]");
                }
                switch (kv[0]) {
                    case "file": {
                        agentOption.setOutputFile(kv[1]);
                        continue block12;
                    }
                    case "to": {
                        agentOption.setToVersion(Integer.parseInt(kv[1]));
                        continue block12;
                    }
                    case "locale": {
                        agentOption.setLocale(new Locale(kv[1]));
                        continue block12;
                    }
                    case "priority": {
                        agentOption.setPriority(kv[1]);
                        continue block12;
                    }
                    default: {
                        throw new RuntimeException("Illegal agent parameters for : [" + param + "]");
                    }
                }
            }
        }
        agentOption.check();
    }

    public static void record(Dependency dependency) {
        try {
            recorder.record(dependency);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new RuntimeException(e);
        }
    }

    public static void recordLoadJar(ProtectionDomain protectionDomain) throws InterruptedException {
        loadedJarRecorder.recordJar(protectionDomain);
    }

    public static void recordLoadClass(String className, ProtectionDomain protectionDomain, byte[] classContent) throws InterruptedException {
        Optional<GuessCallerInfo> callerInfo = AgentFacade.getCallerProvider().guessCallers(3);
        if (callerInfo.isPresent()) {
            Dependency dependency = DependencyBuilder.buildLoadClass(className, callerInfo.isPresent() ? callerInfo.get().getStacktrace() : null, protectionDomain);
            dependency.setNonJdkCallerClass(callerInfo.get().getCallerClasses());
            dependency.setCurrClassBytecode(classContent);
            recorder.record(dependency);
            dependency = dependency.clone();
            dependency.setTarget(new DependTarget.Class(className, DependType.WHOLE_CLASS));
            dependency.setClassSymbol(ClassInspectorInstance.getInstance().getSymbolInClass(classContent));
            recorder.record(dependency);
        }
    }

    private static File getOutputFile() {
        if (agentOption.getOutputFile() != null) {
            AgentFacade.verify(agentOption.getOutputFile());
            return new File(agentOption.getOutputFile());
        }
        SimpleDateFormat sdf = new SimpleDateFormat("yyyyMMddHHmmss");
        return new File("emt4j-" + sdf.format(new Date()) + ".dat");
    }

    private static void verify(String file) {
        File f = new File(file);
        if (f.exists() && f.isDirectory()) {
            throw new RuntimeException("The file :" + file + "cannot be a existing directory!");
        }
        if (f.getParentFile() != null && !f.getParentFile().exists() && f.getParentFile().mkdirs()) {
            throw new RuntimeException("Create parent directory for file : " + file + " failed!");
        }
    }

    public static CallerProvider getCallerProvider() {
        return callerProvider;
    }
}

