/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emt4j.agent.common.rule;

import java.util.stream.Stream;
import org.eclipse.emt4j.agent.common.MethodVisitorParam;
import org.eclipse.emt4j.agent.common.methodvisitor.TransformerFactory;
import org.eclipse.emt4j.agent.common.rule.cldr.CLDRDateFormatVisitor;
import org.eclipse.emt4j.common.DependType;
import org.eclipse.emt4j.common.Dependency;
import org.eclipse.emt4j.common.MethodDesc;
import org.eclipse.emt4j.common.RuleImpl;
import org.eclipse.emt4j.common.rule.ExecutableRule;
import org.eclipse.emt4j.common.rule.model.CheckResult;
import org.eclipse.emt4j.common.rule.model.ConfRuleItem;
import org.eclipse.emt4j.common.rule.model.ConfRules;

@RuleImpl(type="cldr-date-format", priority=1)
public class CLDRDateFormatRule
extends ExecutableRule {
    private static final MethodDesc[] callMethods = new MethodDesc[]{new MethodDesc("java/text/SimpleDateFormat", "java.text.SimpleDateFormat", "format", "(Ljava/util/Date;Ljava/lang/StringBuffer;Ljava/text/Format$FieldDelegate;)Ljava/lang/StringBuffer;"), new MethodDesc("java/text/SimpleDateFormat", "java.text.SimpleDateFormat", "parse", "(Ljava/lang/String;Ljava/text/ParsePosition;)Ljava/util/Date;")};

    public CLDRDateFormatRule(ConfRuleItem confRuleItem, ConfRules confRules) {
        super(confRuleItem, confRules);
    }

    @Override
    public void init() {
        for (MethodDesc methodQuad : callMethods) {
            TransformerFactory.register(methodQuad, mvp -> new CLDRDateFormatVisitor((MethodVisitorParam)mvp));
        }
    }

    @Override
    public CheckResult check(Dependency dependency) {
        if (Stream.of(callMethods).noneMatch(m -> m.getMethodIdentifierNoDesc().equals(dependency.getTarget().asMethod().toMethodIdentifierNoDesc()))) {
            return CheckResult.PASS;
        }
        return CheckResult.FAIL;
    }

    @Override
    public boolean accept(Dependency dependency) {
        return DependType.METHOD == dependency.getDependType();
    }
}

