/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emt4j.agent.common.rule;

import java.util.Collections;
import java.util.stream.Stream;
import org.eclipse.emt4j.agent.common.MethodVisitorParam;
import org.eclipse.emt4j.agent.common.methodvisitor.TransformerFactory;
import org.eclipse.emt4j.agent.common.rule.systemclassloader.GetClassLoaderVisitor;
import org.eclipse.emt4j.agent.common.rule.systemclassloader.SystemClassLoaderMethodVisitor;
import org.eclipse.emt4j.common.DependType;
import org.eclipse.emt4j.common.Dependency;
import org.eclipse.emt4j.common.MethodDesc;
import org.eclipse.emt4j.common.RuleImpl;
import org.eclipse.emt4j.common.classanalyze.ClassInspectorInstance;
import org.eclipse.emt4j.common.rule.ExecutableRule;
import org.eclipse.emt4j.common.rule.model.CheckResult;
import org.eclipse.emt4j.common.rule.model.ConfRuleItem;
import org.eclipse.emt4j.common.rule.model.ConfRules;

@RuleImpl(type="system-classloader-not-a-urlclassloader", priority=1)
public class SystemClassLoaderRule
extends ExecutableRule {
    private static final MethodDesc[] callMethods = new MethodDesc[]{new MethodDesc("java/lang/Class", "java.lang.Class", "getClassLoader", "()Ljava/lang/ClassLoader;"), new MethodDesc("java/lang/ClassLoader", "java.lang.ClassLoader", "getSystemClassLoader", "()Ljava/lang/ClassLoader;"), new MethodDesc("java/lang/ClassLoader", "java.lang.ClassLoader", "getParent", "()Ljava/lang/ClassLoader;")};

    public SystemClassLoaderRule(ConfRuleItem confRuleItem, ConfRules confRules) {
        super(confRuleItem, confRules);
    }

    @Override
    public void init() {
        for (MethodDesc methodQuad : callMethods) {
            TransformerFactory.register(methodQuad, mvp -> new GetClassLoaderVisitor((MethodVisitorParam)mvp));
        }
    }

    @Override
    public CheckResult check(Dependency dependency) {
        if (Stream.of(callMethods).noneMatch(m -> m.getMethodIdentifierNoDesc().equals(dependency.getTarget().asMethod().toMethodIdentifierNoDesc()))) {
            return CheckResult.PASS;
        }
        if (dependency.getCallerClass() != null && dependency.getCallerMethod() != null) {
            SystemClassLoaderMethodVisitor visitor = new SystemClassLoaderMethodVisitor();
            ClassInspectorInstance.getInstance().visitGivenMethodList(dependency.getCallerClass(), Collections.singletonList(dependency.getCallerMethod()), visitor);
            return visitor.isIncompatible() ? CheckResult.FAIL : CheckResult.PASS;
        }
        return CheckResult.FAIL;
    }

    @Override
    public boolean accept(Dependency dependency) {
        return DependType.METHOD == dependency.getDependType();
    }
}

