/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emt4j.agent.common.rule.accessible;

import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Constructor;
import java.lang.reflect.Executable;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Optional;
import org.eclipse.emt4j.agent.common.AgentFacade;
import org.eclipse.emt4j.agent.common.DependencyBuilder;
import org.eclipse.emt4j.agent.common.jdkdependent.CallerInfo;
import org.eclipse.emt4j.agent.common.methodvisitor.BaseEnterCallback;
import org.eclipse.emt4j.common.util.JdkClassUtil;

public class AccessibleCallback
extends BaseEnterCallback {
    public static void recordStaticAccessible(AccessibleObject[] array, boolean flag) {
        Optional<CallerInfo> callerInfo;
        Optional<Class> callerClass;
        if (flag && (callerClass = AgentFacade.getCallerProvider().getNonJdkCallerByDepth(4)).isPresent() && (callerInfo = AgentFacade.getCallerProvider().getCallerInfo(callerClass.get(), 3)).isPresent()) {
            for (AccessibleObject accessibleObject : array) {
                AccessibleCallback.recordAccessible(accessibleObject, callerInfo.get());
            }
        }
    }

    public static void recordInstanceAccessible(AccessibleObject accessibleObject, boolean flag) {
        Optional<Class> callerClass;
        if (flag && (callerClass = AgentFacade.getCallerProvider().getNonJdkCallerByDepth(4)).isPresent()) {
            Optional<CallerInfo> callerInfo = AgentFacade.getCallerProvider().getCallerInfo(callerClass.get(), 3);
            AccessibleCallback.recordAccessible(accessibleObject, callerInfo.get());
        }
    }

    private static void recordAccessible(AccessibleObject accessible, CallerInfo callerInfo) {
        Class<?> declaringClass = null;
        if (accessible instanceof Executable) {
            Method method;
            Constructor constructor;
            declaringClass = ((Executable)accessible).getDeclaringClass();
            if (accessible instanceof Constructor ? Modifier.isPublic((constructor = (Constructor)accessible).getModifiers()) : accessible instanceof Method && Modifier.isPublic((method = (Method)accessible).getModifiers())) {
                return;
            }
        } else if (accessible instanceof Field) {
            Field field = (Field)accessible;
            if (Modifier.isPublic(field.getModifiers())) {
                return;
            }
            declaringClass = ((Field)accessible).getDeclaringClass();
        }
        if (declaringClass != null && !declaringClass.isAnonymousClass() && !declaringClass.isSynthetic() && JdkClassUtil.isJdkClass(declaringClass.getName())) {
            try {
                if (!callerInfo.getCallerClass().getName().startsWith("org.eclipse.emt4j.agent") && !callerInfo.getCallerClass().getName().startsWith("org.eclipse.emt4j.common")) {
                    AgentFacade.record(DependencyBuilder.buildDeepReflection(callerInfo, declaringClass.getName(), callerInfo.getStacktrace()));
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }
}

