/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emt4j.agent.common.rule.cldr;

import java.text.DateFormat;
import java.text.DecimalFormat;
import java.text.SimpleDateFormat;
import java.util.Locale;
import java.util.Optional;
import org.eclipse.emt4j.agent.common.AgentFacade;
import org.eclipse.emt4j.agent.common.DependencyBuilder;
import org.eclipse.emt4j.agent.common.jdkdependent.CallerInfo;
import org.eclipse.emt4j.agent.common.methodvisitor.BaseEnterCallback;

public class CLDRSensitiveEnterCallback
extends BaseEnterCallback {
    private static final SimpleDateFormat enUsFormat = (SimpleDateFormat)DateFormat.getDateTimeInstance(2, 2, Locale.US);
    private static final SimpleDateFormat localFormat = (SimpleDateFormat)DateFormat.getDateTimeInstance(2, 2);

    public static void dateTimeEnter(SimpleDateFormat sdf) {
        Optional<CallerInfo> callerInfo;
        Optional<Class> callerClass;
        if (CLDRSensitiveEnterCallback.isDefaultFormat(sdf) && (callerClass = AgentFacade.getCallerProvider().getNonJdkCallerByDepth(4)).isPresent() && (callerInfo = AgentFacade.getCallerProvider().getCallerInfo(callerClass.get(), 3)).isPresent()) {
            AgentFacade.record(DependencyBuilder.buildMethod(callerInfo.get(), callerInfo.get().getCalleeClass(), callerInfo.get().getCalleeMethod()));
        }
    }

    private static boolean isDefaultFormat(SimpleDateFormat sdf) {
        return sdf != null && (enUsFormat.toPattern().equals(sdf.toPattern()) || localFormat.toPattern().equals(sdf.toPattern()));
    }

    public static void getDayOfFirstWeekEnter() {
        Optional<CallerInfo> callerInfo;
        Optional<Class> callerClass = AgentFacade.getCallerProvider().getNonJdkCallerByDepth(4);
        if (callerClass.isPresent() && (callerInfo = AgentFacade.getCallerProvider().getCallerInfo(callerClass.get(), 3)).isPresent()) {
            AgentFacade.record(DependencyBuilder.buildMethod(callerInfo.get(), callerInfo.get().getCalleeClass(), callerInfo.get().getCalleeMethod()));
        }
    }

    public static void numberFormatEnter(DecimalFormat decimalFormat) {
        Optional<CallerInfo> callerInfo;
        Optional<Class> callerClass;
        if (decimalFormat != null && (!CLDRSensitiveEnterCallback.isEmpty(decimalFormat.getPositivePrefix()) || !CLDRSensitiveEnterCallback.isEmpty(decimalFormat.getPositiveSuffix())) && (callerClass = AgentFacade.getCallerProvider().getNonJdkCallerByDepth(4)).isPresent() && (callerInfo = AgentFacade.getCallerProvider().getCallerInfo(callerClass.get(), 3)).isPresent()) {
            AgentFacade.record(DependencyBuilder.buildMethod(callerInfo.get(), callerInfo.get().getCalleeClass(), callerInfo.get().getCalleeMethod()));
        }
    }

    private static boolean isEmpty(String s) {
        return s == null || "".equals(s);
    }
}

