/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emt4j.agent.jdk11;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Optional;
import org.eclipse.emt4j.agent.common.jdkdependent.CallerInfo;
import org.eclipse.emt4j.agent.common.jdkdependent.CallerProvider;
import org.eclipse.emt4j.agent.common.jdkdependent.GuessCallerInfo;
import org.eclipse.emt4j.common.util.JdkClassUtil;
import org.eclipse.emt4j.common.util.MutableInteger;
import org.eclipse.emt4j.common.util.MutableObject;

public class Java11CallerProvider
implements CallerProvider {
    @Override
    public Optional<GuessCallerInfo> guessCallers(int maxCallerNum) {
        if ("AgentReportWriteThread".equals(Thread.currentThread().getName())) {
            return Optional.empty();
        }
        StackWalker walker = StackWalker.getInstance(StackWalker.Option.RETAIN_CLASS_REFERENCE);
        ArrayList stackTrace = new ArrayList();
        MutableInteger foundNum = new MutableInteger();
        Class[] callerClass = new Class[maxCallerNum];
        walker.forEach(f -> {
            if (!(foundNum.getValue() >= maxCallerNum || f.getClassName().startsWith("org.eclipse.emt4j.agent") || f.getClassName().startsWith("org.eclipse.emt4j.common") || JdkClassUtil.isJdkClass(f.getClassName()))) {
                callerClass[foundNum.getValue()] = f.getDeclaringClass();
                foundNum.inc();
            }
            stackTrace.add(f.toStackTraceElement());
        });
        if (foundNum.getValue() == 0) {
            return Optional.empty();
        }
        GuessCallerInfo guessCallerInfo = new GuessCallerInfo(foundNum.getValue());
        guessCallerInfo.setCallerClasses(callerClass);
        guessCallerInfo.setStacktrace(stackTrace.toArray(new StackTraceElement[stackTrace.size()]));
        return Optional.of(guessCallerInfo);
    }

    @Override
    public Optional<Class> getNonJdkCallerByDepth(int callerDepth) {
        if ("AgentReportWriteThread".equals(Thread.currentThread().getName())) {
            return Optional.empty();
        }
        StackWalker walker = StackWalker.getInstance(StackWalker.Option.RETAIN_CLASS_REFERENCE);
        MutableInteger counter = new MutableInteger();
        MutableObject callerClass = new MutableObject();
        walker.forEach(f -> {
            counter.inc();
            if (counter.getValue() == callerDepth) {
                callerClass.setValue(f.getDeclaringClass());
            }
        });
        if (callerClass.getValue() == null || JdkClassUtil.isJdkClass(((Class)callerClass.getValue()).getName())) {
            return Optional.empty();
        }
        return Optional.of((Class)callerClass.getValue());
    }

    @Override
    public Optional<CallerInfo> getCallerInfo(Class callerClass, int from) {
        StackTraceElement[] stacktrace;
        for (StackTraceElement st : stacktrace = Thread.currentThread().getStackTrace()) {
            if (!st.getClassName().equals(callerClass.getName())) continue;
            CallerInfo callerInfo = new CallerInfo();
            callerInfo.setCallerClass(callerClass);
            callerInfo.setCallerMethod(st.getMethodName());
            callerInfo.setCalleeClass(stacktrace[from].getClassName());
            callerInfo.setCalleeMethod(stacktrace[from].getMethodName());
            callerInfo.setStacktrace(Arrays.copyOfRange(stacktrace, from, stacktrace.length));
            return Optional.of(callerInfo);
        }
        return Optional.empty();
    }
}

