/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emt4j.agent.jdk11;

import java.io.File;
import java.io.IOException;
import java.lang.instrument.Instrumentation;
import java.lang.instrument.UnmodifiableClassException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.jar.JarFile;
import org.eclipse.emt4j.agent.common.JdkDependConfig;
import org.eclipse.emt4j.agent.common.methodvisitor.TransformerFactory;

public class MainAgent {
    private static String[] RULE_CLASS = new String[]{"org.eclipse.emt4j.common.rule.impl.AddExportsRule", "org.eclipse.emt4j.common.rule.impl.IncompatibleJarRule", "org.eclipse.emt4j.common.rule.impl.JvmOptionRule", "org.eclipse.emt4j.common.rule.impl.ReferenceClassRule", "org.eclipse.emt4j.common.rule.impl.TouchedMethodRule", "org.eclipse.emt4j.agent.common.rule.AddOpensRule", "org.eclipse.emt4j.agent.common.rule.AgentReferenceClassRule", "org.eclipse.emt4j.agent.common.rule.AgentTouchedMethodRule", "org.eclipse.emt4j.agent.common.rule.ArraysAsListToArrayRule", "org.eclipse.emt4j.agent.common.rule.CLDRCalendarFirstDayOfWeekRule", "org.eclipse.emt4j.agent.common.rule.CLDRDateFormatRule", "org.eclipse.emt4j.agent.common.rule.CLDRNumberFormatRule", "org.eclipse.emt4j.agent.common.rule.GetJavaVersionRule", "org.eclipse.emt4j.agent.common.rule.PatternCompileRule", "org.eclipse.emt4j.agent.common.rule.SystemClassLoaderRule", "org.eclipse.emt4j.agent.common.rule.SecurityClassGetDeclareFieldRule", "org.eclipse.emt4j.common.rule.impl.DeprecatedAPIRule"};

    public static void premain(String args, Instrumentation instrumentation) {
        MainAgent.versionCheck();
        String agentPath = null;
        if (!(MainAgent.class.getProtectionDomain() == null || MainAgent.class.getProtectionDomain().getCodeSource() == null || MainAgent.class.getProtectionDomain().getCodeSource().getLocation() == null || null != (agentPath = MainAgent.class.getProtectionDomain().getCodeSource().getLocation().getPath()) && agentPath.endsWith(".jar"))) {
            System.err.println("MainAgent must be load with .jar file.Current Path is :" + agentPath);
            return;
        }
        try {
            instrumentation.appendToBootstrapClassLoaderSearch(new JarFile(new File(agentPath)));
            JdkDependConfig jdkDependConfig = new JdkDependConfig(RULE_CLASS, "org.eclipse.emt4j.agent.jdk11.Java11CallerProvider", 11, agentPath);
            Class<?> agentInit = MainAgent.class.getClassLoader().loadClass("org.eclipse.emt4j.agent.common.AgentInit");
            Method initMethod = agentInit.getMethod("init", String.class, Instrumentation.class, JdkDependConfig.class);
            initMethod.invoke(null, args, instrumentation, jdkDependConfig);
            Class[] loadedClasses = instrumentation.getAllLoadedClasses();
            ArrayList<Class> toRetransformClass = new ArrayList<Class>();
            for (Class loadedClass : loadedClasses) {
                if (loadedClass.getName() != null && (loadedClass.getName().startsWith("org.eclipse.emt4j.agent") || loadedClass.getName().startsWith("org.eclipse.emt4j.common")) || !TransformerFactory.needTransform(loadedClass.getName())) continue;
                toRetransformClass.add(loadedClass);
            }
            instrumentation.retransformClasses(toRetransformClass.toArray(new Class[toRetransformClass.size()]));
        }
        catch (IOException | ClassNotFoundException | NoSuchMethodException e) {
            throw new RuntimeException(e);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
        catch (UnmodifiableClassException | InvocationTargetException e) {
            throw new RuntimeException(e);
        }
    }

    private static void versionCheck() {
        String version2 = System.getProperty("java.version");
        if (version2.startsWith("1.")) {
            version2 = version2.substring(2, 3);
        } else {
            int dot = version2.indexOf(".");
            if (dot != -1) {
                version2 = version2.substring(0, dot);
            }
        }
        if (!version2.equals("11")) {
            throw new RuntimeException("Current agent can only run with java11,but actually run with :  " + version2);
        }
    }
}

