/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emt4j.common;

import java.io.Serializable;
import java.net.URL;
import org.eclipse.emt4j.common.DependType;
import org.eclipse.emt4j.common.util.ClassUtil;

public abstract class DependTarget
implements Serializable {
    final DependType type;

    DependTarget(DependType type) {
        this.type = type;
    }

    public Method asMethod() {
        return (Method)this;
    }

    public Class asClass() {
        return (Class)this;
    }

    public Location asLocation() {
        return (Location)this;
    }

    public VMOption asVMOption() {
        return (VMOption)this;
    }

    public DependType type() {
        return this.type;
    }

    public abstract String desc();

    public static class VMOption
    extends DependTarget {
        private final String vmOption;

        public VMOption(String vmOption) {
            super(DependType.VM_OPTION);
            this.vmOption = vmOption;
        }

        public String getVmOption() {
            return this.vmOption;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            VMOption vmOption1 = (VMOption)o;
            return this.vmOption != null ? this.vmOption.equals(vmOption1.vmOption) : vmOption1.vmOption == null;
        }

        public int hashCode() {
            return this.vmOption != null ? this.vmOption.hashCode() : 0;
        }

        @Override
        public String desc() {
            return this.vmOption;
        }
    }

    public static class Class
    extends DependTarget {
        private final String className;

        public Class(String className, DependType type) {
            super(type);
            this.className = className;
        }

        public String getClassName() {
            return this.className;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Class aClass = (Class)o;
            return this.className != null ? this.className.equals(aClass.className) : aClass.className == null;
        }

        public int hashCode() {
            return this.className != null ? this.className.hashCode() : 0;
        }

        @Override
        public String desc() {
            return this.className;
        }
    }

    public static class Location
    extends DependTarget {
        private final String locationExternalForm;

        public Location(URL location) {
            super(DependType.CODE_SOURCE);
            this.locationExternalForm = location.toExternalForm();
        }

        public String getLocationExternalForm() {
            return this.locationExternalForm;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Location location = (Location)o;
            return this.locationExternalForm != null ? this.locationExternalForm.equals(location.locationExternalForm) : location.locationExternalForm == null;
        }

        public int hashCode() {
            return this.locationExternalForm != null ? this.locationExternalForm.hashCode() : 0;
        }

        @Override
        public String desc() {
            return this.locationExternalForm;
        }
    }

    public static class Method
    extends DependTarget {
        private final String className;
        private final String methodName;
        private final String desc;
        public static final String ANY_DESC = "*";

        public Method(String className, String methodName, String desc, DependType type) {
            super(type);
            this.className = className;
            this.methodName = methodName;
            this.desc = desc;
        }

        public String getClassName() {
            return this.className;
        }

        public String getMethodName() {
            return this.methodName;
        }

        public String getDesc() {
            return this.desc;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Method method = (Method)o;
            if (this.className != null ? !this.className.equals(method.className) : method.className != null) {
                return false;
            }
            if (this.methodName != null ? !this.methodName.equals(method.methodName) : method.methodName != null) {
                return false;
            }
            return this.desc != null ? this.desc.equals(method.desc) : method.desc == null;
        }

        public int hashCode() {
            int result = this.className != null ? this.className.hashCode() : 0;
            result = 31 * result + (this.methodName != null ? this.methodName.hashCode() : 0);
            result = 31 * result + (this.desc != null ? this.desc.hashCode() : 0);
            return result;
        }

        public String toMethodIdentifier() {
            return ClassUtil.buildMethodIdentifier(this.className, this.methodName, this.desc);
        }

        public String toMethodIdentifierNoDesc() {
            return ClassUtil.buildMethodIdentifierNoDesc(this.className, this.methodName);
        }

        @Override
        public String desc() {
            return this.toMethodIdentifier();
        }
    }
}

