/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emt4j.common.rule.impl;

import java.util.HashSet;
import java.util.Optional;
import java.util.Set;
import org.eclipse.emt4j.common.DependType;
import org.eclipse.emt4j.common.Dependency;
import org.eclipse.emt4j.common.RuleImpl;
import org.eclipse.emt4j.common.classanalyze.ClassInspectorInstance;
import org.eclipse.emt4j.common.rule.ExecutableRule;
import org.eclipse.emt4j.common.rule.model.CheckResult;
import org.eclipse.emt4j.common.rule.model.ConfRuleItem;
import org.eclipse.emt4j.common.rule.model.ConfRules;
import org.eclipse.emt4j.common.util.ClassUtil;
import org.eclipse.emt4j.common.util.FileUtil;

@RuleImpl(type="reference-class")
public class ReferenceClassRule
extends ExecutableRule {
    protected Set<String> classPackageSet = new HashSet<String>();
    private String classPackageFile;
    private String mustContainInBytecode;
    private String matchType;

    public ReferenceClassRule(ConfRuleItem confRuleItem, ConfRules confRules) {
        super(confRuleItem, confRules);
    }

    @Override
    public void init() {
        try {
            this.classPackageSet.addAll(FileUtil.readPlainTextFromResource(this.confRules.getRuleDataPathPrefix() + this.classPackageFile, false));
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
    }

    @Override
    public CheckResult check(Dependency dependency) {
        Optional<Object> matchPart = Optional.empty();
        String className = dependency.getTarget().asClass().getClassName();
        if ("by-package".equals(this.matchType)) {
            matchPart = ClassUtil.maxLongMatch(className, this.classPackageSet);
        } else if ("by-class".equals(this.matchType)) {
            if (this.classPackageSet.contains(className)) {
                matchPart = Optional.of(className);
            }
        } else {
            throw new RuntimeException("Unknown match-type: " + this.matchType);
        }
        if (matchPart.isPresent()) {
            if ("true".equals(this.mustContainInBytecode) && !this.containInBytecode(dependency.getNonJdkCallerClass(), className)) {
                return CheckResult.PASS;
            }
            return CheckResult.fail();
        }
        return CheckResult.PASS;
    }

    private boolean containInBytecode(Class[] callerClass, String dependency) {
        if (callerClass != null) {
            for (int i = 0; i < callerClass.length; ++i) {
                if (callerClass[i] == null || !ClassInspectorInstance.getInstance().getReferenceClassSet(callerClass[i]).contains(dependency)) continue;
                return true;
            }
            return false;
        }
        return true;
    }

    @Override
    public boolean accept(Dependency dependency) {
        return DependType.CLASS == dependency.getDependType() || DependType.METHOD_TO_CLASS_DEEP_REFLECTION == dependency.getDependType();
    }

    public void setClassPackageFile(String classPackageFile) {
        this.classPackageFile = classPackageFile;
    }

    public void setMatchType(String matchType) {
        this.matchType = matchType;
    }

    public void setMustContainInBytecode(String mustContainInBytecode) {
        this.mustContainInBytecode = mustContainInBytecode;
    }
}

