/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emt4j.common.rule.model;

import java.util.Arrays;
import java.util.function.BiPredicate;

public class Version {
    private String version;

    public Version(String version2) {
        this.version = version2;
    }

    public boolean lt(String toCompare) {
        return this.doCompare(this.version, toCompare, (a, b) -> a < b);
    }

    public boolean le(String toCompare) {
        return this.doCompare(this.version, toCompare, (a, b) -> a <= b);
    }

    public boolean eq(String toCompare) {
        return this.version.equals(toCompare);
    }

    public boolean ne(String toCompare) {
        return !this.eq(toCompare);
    }

    public boolean ge(String toCompare) {
        return this.doCompare(this.version, toCompare, (a, b) -> a >= b);
    }

    public boolean gt(String toCompare) {
        return this.doCompare(this.version, toCompare, (a, b) -> a > b);
    }

    private boolean doCompare(String aVersion, String bVersion, BiPredicate<Integer, Integer> predicate) {
        int[] b;
        int[] a = this.toInt(aVersion);
        if (a.length != (b = this.toInt(bVersion)).length) {
            if (a.length > b.length) {
                b = this.align(a, b);
            } else if (a.length < b.length) {
                a = this.align(b, a);
            }
        }
        for (int i = 0; i < a.length; ++i) {
            if (predicate.test(a[i], b[i])) {
                if (a[i] == b[i] && i != a.length - 1) continue;
                return true;
            }
            return false;
        }
        return false;
    }

    private int[] align(int[] alignTo, int[] needAlign) {
        int[] newArray = new int[alignTo.length];
        Arrays.fill(newArray, 0);
        System.arraycopy(needAlign, 0, newArray, 0, needAlign.length);
        return newArray;
    }

    private int[] toInt(String version2) {
        String[] array = version2.split("\\.");
        int[] intArray = new int[array.length];
        for (int i = 0; i < array.length; ++i) {
            intArray[i] = Integer.parseInt(array[i]);
        }
        return intArray;
    }
}

