/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emt4j.common.staticanalysis.impl;

import java.util.List;
import java.util.Set;
import org.eclipse.emt4j.common.staticanalysis.impl.BaseAnalyzer;
import soot.Local;
import soot.SootMethod;
import soot.Unit;
import soot.Value;
import soot.ValueBox;
import soot.jimple.JimpleBody;
import soot.jimple.internal.JStaticInvokeExpr;
import soot.jimple.internal.JVirtualInvokeExpr;
import soot.toolkits.graph.ExceptionalUnitGraph;
import soot.toolkits.graph.ExceptionalUnitGraphFactory;
import soot.toolkits.scalar.SimpleLocalDefs;

public class CLDRDateFormatAnalyzer
extends BaseAnalyzer {
    @Override
    public String rule() {
        return "cldr-date-format";
    }

    @Override
    boolean doAnalyze(SootMethod method) {
        JimpleBody body = (JimpleBody)method.retrieveActiveBody();
        ExceptionalUnitGraph graph = ExceptionalUnitGraphFactory.createExceptionalUnitGraph(body);
        SimpleLocalDefs localDefs = new SimpleLocalDefs(graph);
        for (Unit unit : body.getUnits()) {
            List<ValueBox> boxes = unit.getUseBoxes();
            for (ValueBox box : boxes) {
                List<ValueBox> useBoxes;
                Local local;
                JVirtualInvokeExpr invoke;
                SootMethod invokeMethod;
                Value value = box.getValue();
                if (!(value instanceof JVirtualInvokeExpr) || !(invokeMethod = (invoke = (JVirtualInvokeExpr)value).getMethod()).getDeclaringClass().getName().equals("java.text.SimpleDateFormat") && !invokeMethod.getDeclaringClass().getName().equals("java.text.DateFormat") || !invokeMethod.getName().equals("format") && !method.getName().equals("parse") || invokeMethod.getParameterCount() <= 0 || !CLDRDateFormatAnalyzer.isTarget(localDefs, unit, local = (Local)(useBoxes = invoke.getUseBoxes()).get(0).getValue())) continue;
                return true;
            }
        }
        return false;
    }

    private static boolean isTarget(SimpleLocalDefs localDefs, Unit unit, Local local) {
        Set<Value> defs = CLDRDateFormatAnalyzer.getDefValues(localDefs, unit, local);
        for (Value def : defs) {
            JStaticInvokeExpr invoke;
            SootMethod method;
            if (!(def instanceof JStaticInvokeExpr) || !(method = (invoke = (JStaticInvokeExpr)def).getMethod()).getDeclaringClass().getName().equals("java.text.DateFormat") || !method.getName().equals("getDateTimeInstance") && !method.getName().equals("getInstance")) continue;
            return true;
        }
        return false;
    }
}

