/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emt4j.common.staticanalysis.impl;

import java.util.List;
import java.util.Set;
import org.eclipse.emt4j.common.staticanalysis.impl.BaseAnalyzer;
import soot.ArrayType;
import soot.Local;
import soot.RefType;
import soot.SootMethod;
import soot.Type;
import soot.Unit;
import soot.Value;
import soot.ValueBox;
import soot.jimple.JimpleBody;
import soot.jimple.internal.AbstractInstanceInvokeExpr;
import soot.jimple.internal.AbstractInvokeExpr;
import soot.jimple.internal.JCastExpr;
import soot.jimple.internal.JInterfaceInvokeExpr;
import soot.jimple.internal.JStaticInvokeExpr;
import soot.toolkits.graph.ExceptionalUnitGraph;
import soot.toolkits.graph.ExceptionalUnitGraphFactory;
import soot.toolkits.scalar.SimpleLocalDefs;

public class CastArraysAsListToArrayAnalyzer
extends BaseAnalyzer {
    @Override
    public String rule() {
        return "cast-arrays-as-list-to-array";
    }

    @Override
    boolean doAnalyze(SootMethod method) {
        JimpleBody body = (JimpleBody)method.retrieveActiveBody();
        ExceptionalUnitGraph graph = ExceptionalUnitGraphFactory.createExceptionalUnitGraph(body);
        SimpleLocalDefs localDefs = new SimpleLocalDefs(graph);
        for (Unit unit : body.getUnits()) {
            List<ValueBox> boxes = unit.getUseBoxes();
            for (ValueBox box : boxes) {
                Local local;
                Type castType;
                Value value = box.getValue();
                if (!(value instanceof JCastExpr) || !((castType = ((JCastExpr)value).getCastType()) instanceof ArrayType) || (castType = ((ArrayType)castType).baseType) instanceof RefType && ((RefType)castType).getClassName().equals("java.lang.Object") || !CastArraysAsListToArrayAnalyzer.isTarget(localDefs, unit, local = (Local)((JCastExpr)value).getOpBox().getValue())) continue;
                return true;
            }
        }
        return false;
    }

    private static boolean isTarget(SimpleLocalDefs localDefs, Unit unit, Local local) {
        AbstractInvokeExpr invoke;
        SootMethod method;
        Set<Value> defs = CastArraysAsListToArrayAnalyzer.getDefValues(localDefs, unit, local);
        Local receiver = null;
        for (Value def : defs) {
            if (!(def instanceof JInterfaceInvokeExpr) || !(method = (invoke = (JInterfaceInvokeExpr)def).getMethod()).getDeclaringClass().getName().equals("java.util.List") || !method.getName().equals("toArray") || method.getParameterCount() != 0) continue;
            receiver = (Local)((AbstractInstanceInvokeExpr)invoke).getBase();
        }
        if (receiver != null) {
            defs = CastArraysAsListToArrayAnalyzer.getDefValues(localDefs, unit, receiver);
            for (Value def : defs) {
                if (!(def instanceof JStaticInvokeExpr) || !(method = (invoke = (JStaticInvokeExpr)def).getMethod()).getDeclaringClass().getName().equals("java.util.Arrays") || !method.getName().equals("asList")) continue;
                return true;
            }
        }
        return false;
    }
}

