/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emt4j.common.staticanalysis.impl;

import java.util.List;
import java.util.Set;
import org.eclipse.emt4j.common.staticanalysis.impl.BaseAnalyzer;
import soot.Local;
import soot.RefType;
import soot.SootMethod;
import soot.Type;
import soot.Unit;
import soot.Value;
import soot.ValueBox;
import soot.jimple.JimpleBody;
import soot.jimple.internal.JCastExpr;
import soot.jimple.internal.JStaticInvokeExpr;
import soot.toolkits.graph.ExceptionalUnitGraph;
import soot.toolkits.graph.ExceptionalUnitGraphFactory;
import soot.toolkits.scalar.SimpleLocalDefs;

public class CastSystemClassLoaderToURLClassLoaderAnalyzer
extends BaseAnalyzer {
    @Override
    public String rule() {
        return "cast-system-classloader-to-url-classloader";
    }

    @Override
    boolean doAnalyze(SootMethod method) {
        JimpleBody body = (JimpleBody)method.retrieveActiveBody();
        ExceptionalUnitGraph graph = ExceptionalUnitGraphFactory.createExceptionalUnitGraph(body);
        SimpleLocalDefs localDefs = new SimpleLocalDefs(graph);
        for (Unit unit : body.getUnits()) {
            List<ValueBox> boxes = unit.getUseBoxes();
            for (ValueBox box : boxes) {
                Local local;
                Type castType;
                Value value = box.getValue();
                if (!(value instanceof JCastExpr) || !((castType = ((JCastExpr)value).getCastType()) instanceof RefType) || !((RefType)castType).getClassName().equals("java.net.URLClassLoader") || !CastSystemClassLoaderToURLClassLoaderAnalyzer.isTarget(localDefs, unit, local = (Local)((JCastExpr)value).getOpBox().getValue())) continue;
                return true;
            }
        }
        return false;
    }

    private static boolean isTarget(SimpleLocalDefs localDefs, Unit unit, Local local) {
        Set<Value> defs = CastSystemClassLoaderToURLClassLoaderAnalyzer.getDefValues(localDefs, unit, local);
        for (Value def : defs) {
            JStaticInvokeExpr invoke;
            SootMethod method;
            if (!(def instanceof JStaticInvokeExpr) || !(method = (invoke = (JStaticInvokeExpr)def).getMethod()).getDeclaringClass().getName().equals("java.lang.ClassLoader") || !method.getName().equals("getSystemClassLoader")) continue;
            return true;
        }
        return false;
    }
}

