/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emt4j.common.util;

import java.net.MalformedURLException;
import java.net.URL;
import org.eclipse.emt4j.common.util.refclass.Handler;

public class ClassURL {
    private static final String CLASS_PROTOCOL = "refclass";

    public static URL create(String file, String className, String methodName) {
        try {
            return new URL(CLASS_PROTOCOL, null, -1, ClassURL.emptyIfNull(file) + "!/" + className + "!/" + ClassURL.emptyIfNull(methodName), new Handler());
        }
        catch (MalformedURLException e) {
            return null;
        }
    }

    public static URL create(String className, String methodName) {
        return ClassURL.create(null, className, methodName);
    }

    public static void registerUrlProtocolHandler() {
        String handlers = System.getProperty("java.protocol.handler.pkgs", "");
        System.setProperty("java.protocol.handler.pkgs", "".equals(handlers) ? "org.eclipse.emt4j.common.util" : handlers + "|org.eclipse.emt4j.common.util");
        ClassURL.resetCachedUrlHandlers();
    }

    private static void resetCachedUrlHandlers() {
        try {
            URL.setURLStreamHandlerFactory(null);
        }
        catch (Error error) {
            // empty catch block
        }
    }

    private static String emptyIfNull(String file) {
        return file == null ? "" : file;
    }
}

