/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emt4j.common.util;

import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.emt4j.common.JdkMigrationException;

public class FileUtil {
    public static List<String> readPlainTextFromResource(String resourcePath, boolean includeComment) {
        try {
            ArrayList<String> lines = new ArrayList<String>();
            try (BufferedReader br = new BufferedReader(new InputStreamReader(FileUtil.class.getResourceAsStream(resourcePath), StandardCharsets.UTF_8));){
                String line = br.readLine();
                while (line != null) {
                    if (!line.startsWith("#") || includeComment) {
                        lines.add(line);
                    }
                    line = br.readLine();
                }
            }
            return lines;
        }
        catch (Exception e) {
            throw new JdkMigrationException("Read resource failed by path:" + resourcePath, e);
        }
    }
}

