/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emt4j.common.util;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.emt4j.common.rule.model.JarFileInfo;

public class JarFileInfoUtil {
    private static PatternWithNumber[] ALL_PATTERN = new PatternWithNumber[]{new PatternWithNumber(4, Pattern.compile(".*(\\d+)\\.(\\d+)\\.(\\d+)\\.(\\d+).*")), new PatternWithNumber(3, Pattern.compile(".*(\\d+)\\.(\\d+)\\.(\\d+).*")), new PatternWithNumber(2, Pattern.compile(".*(\\d+)\\.(\\d+).*")), new PatternWithNumber(1, Pattern.compile(".*(\\d+).*"))};

    public static Optional<JarFileInfo> match(String jarFilePath) {
        Optional<String> jarFileName = JarFileInfoUtil.stripPath(jarFilePath);
        if (!jarFileName.isPresent()) {
            return Optional.empty();
        }
        JarFileInfo jarFileInfo = new JarFileInfo();
        for (PatternWithNumber pn : ALL_PATTERN) {
            Matcher m = pn.pattern.matcher(jarFileName.get());
            if (!m.find()) continue;
            ArrayList<String> version2 = new ArrayList<String>();
            for (int i = 1; i <= pn.groupCount; ++i) {
                version2.add(m.group(i));
            }
            String prefix = jarFileName.get().substring(0, m.start(1));
            jarFileInfo.setVersion(jarFileName.get().substring(m.start(1), m.end(pn.groupCount)));
            JarFileInfoUtil.sortArtifactFragments(prefix, jarFileInfo);
            jarFileInfo.setJarFileName(jarFileName.get());
            return Optional.of(jarFileInfo);
        }
        return Optional.empty();
    }

    public static void sortArtifactFragments(String artifactId, JarFileInfo jarFileInfo) {
        String[] part = artifactId.split("\\p{Punct}");
        ArrayList<String> artifact = new ArrayList<String>();
        for (String p : part) {
            if (p == null || "".equals(p) || JarFileInfoUtil.isNumeric(p) || (p.charAt(0) == 'v' || p.charAt(0) == 'V') && JarFileInfoUtil.isNumeric(p.substring(1))) continue;
            artifact.add(p);
        }
        jarFileInfo.setArtifactFragments(artifact.toArray(new String[artifact.size()]));
        Collections.sort(artifact);
        jarFileInfo.setOrderedArtifactFragments(artifact.toArray(new String[artifact.size()]));
    }

    public static String[] sortArtifactFragments(String artifactId) {
        String[] part = artifactId.split("\\p{Punct}");
        ArrayList<String> artifact = new ArrayList<String>();
        for (String p : part) {
            if (p == null || "".equals(p) || JarFileInfoUtil.isNumeric(p) || (p.charAt(0) == 'v' || p.charAt(0) == 'V') && JarFileInfoUtil.isNumeric(p.substring(1))) continue;
            artifact.add(p);
        }
        Collections.sort(artifact);
        return artifact.toArray(new String[artifact.size()]);
    }

    private static Optional<String> stripPath(String jarFilePath) {
        int start;
        if (null == jarFilePath || "".equals(jarFilePath)) {
            return Optional.empty();
        }
        int end = jarFilePath.lastIndexOf(".jar");
        if (-1 == end) {
            return Optional.empty();
        }
        for (start = end; start > 0; --start) {
            char c = jarFilePath.charAt(start);
            if (c != '/' && c != '\\') continue;
            ++start;
            break;
        }
        return Optional.of(jarFilePath.substring(start, end));
    }

    public static boolean isNumeric(CharSequence cs) {
        if (cs == null || cs.length() == 0) {
            return false;
        }
        int sz = cs.length();
        for (int i = 0; i < sz; ++i) {
            if (Character.isDigit(cs.charAt(i))) continue;
            return false;
        }
        return true;
    }

    private static class PatternWithNumber {
        Pattern pattern;
        int groupCount;

        public PatternWithNumber(int groupCount, Pattern pattern) {
            this.pattern = pattern;
            this.groupCount = groupCount;
        }
    }
}

