/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emt4j.org.mvel2.ast;

import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.emt4j.org.mvel2.CompileException;
import org.eclipse.emt4j.org.mvel2.MVEL;
import org.eclipse.emt4j.org.mvel2.ParserContext;
import org.eclipse.emt4j.org.mvel2.ast.BlockNode;
import org.eclipse.emt4j.org.mvel2.integration.VariableResolver;
import org.eclipse.emt4j.org.mvel2.integration.VariableResolverFactory;
import org.eclipse.emt4j.org.mvel2.util.ExecutionStack;
import org.eclipse.emt4j.org.mvel2.util.ParseTools;

public class Stacklang
extends BlockNode {
    List<Instruction> instructionList;
    ParserContext pCtx;
    static final Map<String, Integer> opcodes = new HashMap<String, Integer>();

    public Stacklang(char[] expr, int blockStart, int blockOffset, int fields, ParserContext pCtx) {
        super(pCtx);
        this.expr = expr;
        this.blockStart = blockStart;
        this.blockOffset = blockOffset;
        this.fields = fields | 0x400000;
        String[] instructions = new String(expr, blockStart, blockOffset).split(";");
        this.instructionList = new ArrayList<Instruction>(instructions.length);
        for (String s : instructions) {
            this.instructionList.add(Stacklang.parseInstruction(s.trim()));
        }
        this.pCtx = pCtx;
    }

    @Override
    public Object getReducedValueAccelerated(Object ctx, Object thisValue, VariableResolverFactory factory) {
        ExecutionStack stk = new ExecutionStack();
        stk.push(this.getReducedValue(stk, thisValue, factory));
        if (stk.isReduceable()) {
            while (true) {
                stk.op();
                if (!stk.isReduceable()) break;
                stk.xswap();
            }
        }
        return stk.peek();
    }

    @Override
    public Object getReducedValue(Object ctx, Object thisValue, VariableResolverFactory factory) {
        ExecutionStack stack = (ExecutionStack)ctx;
        int instructionListSize = this.instructionList.size();
        block29: for (int i1 = 0; i1 < instructionListSize; ++i1) {
            Instruction instruction = this.instructionList.get(i1);
            System.out.println(stack.toString() + " >> " + instruction.opcode + ":" + instruction.expr);
            switch (instruction.opcode) {
                case 109: {
                    if (instruction.cache == null) {
                        instruction.cache = factory.createVariable(instruction.expr, stack.peek());
                        continue block29;
                    }
                    ((VariableResolver)instruction.cache).setValue(stack.peek());
                    continue block29;
                }
                case 104: {
                    if (instruction.cache == null) {
                        instruction.cache = factory.getVariableResolver(instruction.expr);
                    }
                    stack.push(((VariableResolver)instruction.cache).getValue());
                    continue block29;
                }
                case 107: {
                    try {
                        Field field;
                        if (stack.isEmpty() || !(stack.peek() instanceof Class)) {
                            throw new CompileException("getfield without class", this.expr, this.blockStart);
                        }
                        if (instruction.cache == null) {
                            field = ((Class)stack.pop()).getField(instruction.expr);
                            instruction.cache = field;
                        } else {
                            stack.discard();
                            field = (Field)instruction.cache;
                        }
                        stack.push(field.get(stack.pop()));
                        continue block29;
                    }
                    catch (Exception e) {
                        throw new CompileException("field access error", this.expr, this.blockStart, e);
                    }
                }
                case 108: {
                    try {
                        if (stack.isEmpty() || !(stack.peek() instanceof Class)) {
                            throw new CompileException("storefield without class", this.expr, this.blockStart);
                        }
                        Class cls = (Class)stack.pop();
                        Object val = stack.pop();
                        cls.getField(instruction.expr).set(stack.pop(), val);
                        stack.push(val);
                        continue block29;
                    }
                    catch (Exception e) {
                        throw new CompileException("field access error", this.expr, this.blockStart, e);
                    }
                }
                case 105: {
                    try {
                        if (instruction.cache == null) {
                            instruction.cache = ParseTools.createClass(instruction.expr, this.pCtx);
                        }
                        stack.push(instruction.cache);
                        continue block29;
                    }
                    catch (ClassNotFoundException e) {
                        throw new CompileException("error", this.expr, this.blockStart, e);
                    }
                }
                case 106: {
                    Method m;
                    ExecutionStack call = new ExecutionStack();
                    while (!stack.isEmpty() && !(stack.peek() instanceof Class)) {
                        call.push(stack.pop());
                    }
                    if (stack.isEmpty()) {
                        throw new CompileException("invoke without class", this.expr, this.blockStart);
                    }
                    Object[] parms = new Object[call.size()];
                    int i = 0;
                    while (!call.isEmpty()) {
                        parms[i] = call.pop();
                        ++i;
                    }
                    if ("<init>".equals(instruction.expr)) {
                        Constructor c;
                        if (instruction.cache == null) {
                            c = ParseTools.getBestConstructorCandidate(parms, (Class)stack.pop(), false);
                            instruction.cache = c;
                        } else {
                            c = (Constructor)instruction.cache;
                        }
                        try {
                            stack.push(c.newInstance(parms));
                            continue block29;
                        }
                        catch (Exception e) {
                            throw new CompileException("instantiation error", this.expr, this.blockStart, e);
                        }
                    }
                    if (instruction.cache == null) {
                        Class cls = (Class)stack.pop();
                        m = ParseTools.getBestCandidate(parms, instruction.expr, cls, cls.getDeclaredMethods(), false);
                        instruction.cache = m;
                    } else {
                        stack.discard();
                        m = (Method)instruction.cache;
                    }
                    try {
                        stack.push(m.invoke(stack.isEmpty() ? null : stack.pop(), parms));
                        continue block29;
                    }
                    catch (Exception e) {
                        throw new CompileException("invokation error", this.expr, this.blockStart, e);
                    }
                }
                case 102: {
                    if (instruction.cache == null) {
                        instruction.cache = MVEL.eval(instruction.expr, ctx, factory);
                    }
                    stack.push(instruction.cache);
                    continue block29;
                }
                case 103: {
                    stack.pop();
                    continue block29;
                }
                case 110: {
                    stack.dup();
                    continue block29;
                }
                case 111: {
                    continue block29;
                }
                case 113: {
                    if (!stack.popBoolean().booleanValue()) continue block29;
                }
                case 112: {
                    if (instruction.cache != null) {
                        i1 = (Integer)instruction.cache;
                        continue block29;
                    }
                    for (int i2 = 0; i2 < this.instructionList.size(); ++i2) {
                        Instruction ins = this.instructionList.get(i2);
                        if (ins.opcode != 111 || !instruction.expr.equals(ins.expr)) continue;
                        i1 = i2;
                        instruction.cache = i1;
                        continue block29;
                    }
                    continue block29;
                }
                case 18: {
                    stack.push(stack.pop().equals(stack.pop()));
                    continue block29;
                }
                case 19: {
                    stack.push(!stack.pop().equals(stack.pop()));
                    continue block29;
                }
                case 114: {
                    stack.op();
                    continue block29;
                }
                case 116: {
                    stack.xswap2();
                    continue block29;
                }
                case 115: {
                    Object o = stack.pop();
                    Object o2 = stack.pop();
                    stack.push(o);
                    stack.push(o2);
                }
            }
        }
        return stack.pop();
    }

    private static Instruction parseInstruction(String s) {
        String keyword;
        int split = s.indexOf(32);
        Instruction instruction = new Instruction();
        String string = keyword = split == -1 ? s : s.substring(0, split);
        if (opcodes.containsKey(keyword)) {
            instruction.opcode = opcodes.get(keyword);
        }
        if (keyword != s) {
            instruction.expr = s.substring(split + 1);
        }
        return instruction;
    }

    static {
        opcodes.put("push", 102);
        opcodes.put("pop", 103);
        opcodes.put("load", 104);
        opcodes.put("ldtype", 105);
        opcodes.put("invoke", 106);
        opcodes.put("store", 109);
        opcodes.put("getfield", 107);
        opcodes.put("storefield", 108);
        opcodes.put("dup", 110);
        opcodes.put("jump", 112);
        opcodes.put("jumpif", 113);
        opcodes.put("label", 111);
        opcodes.put("eq", 18);
        opcodes.put("ne", 19);
        opcodes.put("reduce", 114);
        opcodes.put("xswap", 116);
        opcodes.put("swap", 115);
    }

    private static class Instruction {
        int opcode;
        String expr;
        Object cache;

        private Instruction() {
        }
    }
}

