/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emt4j.org.mvel2.compiler;

import java.lang.reflect.Field;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.eclipse.emt4j.org.mvel2.CompileException;
import org.eclipse.emt4j.org.mvel2.ErrorDetail;
import org.eclipse.emt4j.org.mvel2.MVEL;
import org.eclipse.emt4j.org.mvel2.ParserContext;
import org.eclipse.emt4j.org.mvel2.ast.Function;
import org.eclipse.emt4j.org.mvel2.optimizers.AbstractOptimizer;
import org.eclipse.emt4j.org.mvel2.optimizers.impl.refl.nodes.WithAccessor;
import org.eclipse.emt4j.org.mvel2.util.ErrorUtil;
import org.eclipse.emt4j.org.mvel2.util.NullType;
import org.eclipse.emt4j.org.mvel2.util.ParseTools;
import org.eclipse.emt4j.org.mvel2.util.PropertyTools;
import org.eclipse.emt4j.org.mvel2.util.StringAppender;

public class PropertyVerifier
extends AbstractOptimizer {
    private static final int DONE = -1;
    private static final int NORM = 0;
    private static final int METH = 1;
    private static final int COL = 2;
    private static final int WITH = 3;
    private List<String> inputs = new LinkedList<String>();
    private boolean first = false;
    private boolean classLiteral = false;
    private boolean resolvedExternally;
    private boolean methodCall = false;
    private boolean deepProperty = false;
    private boolean fqcn = false;
    private Map<String, Type> paramTypes;
    private Class ctx = null;

    public PropertyVerifier(char[] property, ParserContext parserContext) {
        this.expr = property;
        this.length = this.end = property.length;
        this.pCtx = parserContext;
    }

    public PropertyVerifier(char[] property, int start, int offset, ParserContext parserContext) {
        this.expr = property;
        this.start = start;
        this.length = offset;
        this.end = start + offset;
        this.pCtx = parserContext;
    }

    public PropertyVerifier(String property, ParserContext parserContext) {
        this.expr = property.toCharArray();
        this.length = this.end = this.expr.length;
        this.pCtx = parserContext;
    }

    public PropertyVerifier(String property, ParserContext parserContext, Class root) {
        this.expr = property.toCharArray();
        this.end = this.length = this.expr.length;
        if (property.length() > 0 && property.charAt(0) == '.') {
            this.start = 1;
            this.st = 1;
            this.cursor = 1;
        }
        this.pCtx = parserContext;
        this.ctx = root;
    }

    public List<String> getInputs() {
        return this.inputs;
    }

    public void setInputs(List<String> inputs) {
        this.inputs = inputs;
    }

    public Class analyze() {
        this.cursor = this.start;
        this.resolvedExternally = true;
        if (this.ctx == null) {
            this.ctx = Object.class;
            this.first = true;
        }
        while (this.cursor < this.end) {
            this.classLiteral = false;
            switch (this.nextSubToken()) {
                case 0: {
                    this.ctx = this.getBeanProperty(this.ctx, this.capture());
                    break;
                }
                case 1: {
                    this.ctx = this.getMethod(this.ctx, this.capture());
                    break;
                }
                case 2: {
                    this.ctx = this.getCollectionProperty(this.ctx, this.capture());
                    break;
                }
                case 3: {
                    this.ctx = this.getWithProperty(this.ctx);
                    break;
                }
            }
            if (this.cursor < this.length && !this.first) {
                this.deepProperty = true;
            }
            this.first = false;
        }
        return this.ctx;
    }

    private void recordTypeParmsForProperty(String property) {
        if (this.pCtx.isStrictTypeEnforcement()) {
            this.pCtx.setLastTypeParameters(this.pCtx.getTypeParametersAsArray(property));
        }
    }

    private Class getBeanProperty(Class ctx, String property) {
        Class cls;
        block34: {
            boolean switchStateReg;
            block36: {
                block35: {
                    Class importedClass;
                    Member member;
                    if (this.first) {
                        if (this.pCtx.hasVarOrInput(property)) {
                            if (this.pCtx.isStrictTypeEnforcement()) {
                                this.recordTypeParmsForProperty(property);
                            }
                            return this.pCtx.getVarOrInputType(property);
                        }
                        if (this.pCtx.hasImport(property)) {
                            this.resolvedExternally = false;
                            return this.pCtx.getImport(property);
                        }
                        if (!this.pCtx.isStrongTyping()) {
                            return Object.class;
                        }
                        if (this.pCtx.hasVarOrInput("this")) {
                            if (this.pCtx.isStrictTypeEnforcement()) {
                                this.recordTypeParmsForProperty("this");
                            }
                            ctx = this.pCtx.getVarOrInputType("this");
                            this.resolvedExternally = false;
                        }
                    }
                    this.st = this.cursor;
                    Member member2 = member = ctx != null ? PropertyTools.getFieldOrAccessor(ctx, property) : null;
                    if (MVEL.COMPILER_OPT_SUPPORT_JAVA_STYLE_CLASS_LITERALS && "class".equals(property)) {
                        return Class.class;
                    }
                    if (member instanceof Field) {
                        if (this.pCtx.isStrictTypeEnforcement()) {
                            Field f = (Field)member;
                            if (f.getGenericType() != null) {
                                TypeVariable tv;
                                Type paramType;
                                if (f.getGenericType() instanceof ParameterizedType) {
                                    ParameterizedType pt = (ParameterizedType)f.getGenericType();
                                    this.pCtx.setLastTypeParameters(pt.getActualTypeArguments());
                                    Type[] gpt = pt.getActualTypeArguments();
                                    TypeVariable<Class<?>>[] classArgs = PropertyVerifier.type2Class(pt.getRawType()).getTypeParameters();
                                    if (gpt.length > 0 && this.paramTypes == null) {
                                        this.paramTypes = new HashMap<String, Type>();
                                    }
                                    for (int i = 0; i < gpt.length; ++i) {
                                        this.paramTypes.put(classArgs[i].toString(), gpt[i]);
                                    }
                                } else if (f.getGenericType() instanceof TypeVariable && (paramType = this.paramTypes.remove((tv = (TypeVariable)f.getGenericType()).getName())) != null && paramType instanceof Class) {
                                    return (Class)paramType;
                                }
                            }
                            return f.getType();
                        }
                        return ((Field)member).getType();
                    }
                    if (member != null) {
                        return this.getReturnType(ctx, (Method)member);
                    }
                    if (this.pCtx != null && this.first && this.pCtx.hasImport(property) && (importedClass = this.pCtx.getImport(property)) != null) {
                        return this.pCtx.getImport(property);
                    }
                    if (this.pCtx == null || this.pCtx.getLastTypeParameters() == null || this.pCtx.getLastTypeParameters().length == 0) break block34;
                    if (!Collection.class.isAssignableFrom(ctx)) break block35;
                    switchStateReg = false;
                    if (!false) break block36;
                }
                if (!Map.class.isAssignableFrom(ctx)) break block34;
                switchStateReg = true;
                if (!true) break block34;
            }
            Type parm = this.pCtx.getLastTypeParameters()[switchStateReg ? 1 : 0];
            this.pCtx.setLastTypeParameters(null);
            return parm instanceof ParameterizedType ? Object.class : (Class)parm;
        }
        if (this.pCtx != null && "length".equals(property) && ctx.isArray()) {
            return Integer.class;
        }
        Object tryStaticMethodRef = this.tryStaticAccess();
        if (tryStaticMethodRef != null) {
            this.fqcn = true;
            this.resolvedExternally = false;
            if (tryStaticMethodRef instanceof Class) {
                this.classLiteral = !MVEL.COMPILER_OPT_SUPPORT_JAVA_STYLE_CLASS_LITERALS || !new String(this.expr, this.end - 6, 6).equals(".class");
                return this.classLiteral ? (Class)tryStaticMethodRef : Class.class;
            }
            if (tryStaticMethodRef instanceof Field) {
                try {
                    return ((Field)tryStaticMethodRef).get(null).getClass();
                }
                catch (Exception e) {
                    throw new CompileException("in verifier: ", this.expr, this.start, e);
                }
            }
            try {
                return ((Method)tryStaticMethodRef).getReturnType();
            }
            catch (Exception e) {
                throw new CompileException("in verifier: ", this.expr, this.start, e);
            }
        }
        if (ctx != null) {
            try {
                return ParseTools.findClass(this.variableFactory, ctx.getName() + "$" + property, this.pCtx);
            }
            catch (ClassNotFoundException e) {
                // empty catch block
            }
        }
        if ((this.pCtx != null && this.pCtx.getParserConfiguration() != null ? this.pCtx.getParserConfiguration().isAllowNakedMethCall() : MVEL.COMPILER_OPT_ALLOW_NAKED_METH_CALL) && (cls = this.getMethod(ctx, property)) != Object.class) {
            return cls;
        }
        if (this.pCtx.isStrictTypeEnforcement()) {
            throw new CompileException("unqualified type in strict mode for: " + property, this.expr, this.tkStart);
        }
        return Object.class;
    }

    private Class getReturnType(Class context, Method m) {
        Class<?> declaringClass = m.getDeclaringClass();
        if (context == declaringClass) {
            return this.returnGenericType(m);
        }
        Type returnType = m.getGenericReturnType();
        if (returnType instanceof TypeVariable) {
            Class superClass;
            String typeName = ((TypeVariable)returnType).getName();
            Type superType = context.getGenericSuperclass();
            for (superClass = context.getSuperclass(); superClass != null && superClass != declaringClass; superClass = superClass.getSuperclass()) {
                superType = superClass.getGenericSuperclass();
            }
            if (superClass == null) {
                return this.returnGenericType(m);
            }
            if (superType instanceof ParameterizedType) {
                TypeVariable<Class<T>>[] typeParams = superClass.getTypeParameters();
                int typePos = -1;
                for (int i = 0; i < typeParams.length; ++i) {
                    if (!typeParams[i].getName().equals(typeName)) continue;
                    typePos = i;
                    break;
                }
                if (typePos < 0) {
                    return this.returnGenericType(m);
                }
                Type actualType = ((ParameterizedType)superType).getActualTypeArguments()[typePos];
                return actualType instanceof Class ? (Class<?>)actualType : this.returnGenericType(m);
            }
        }
        return this.returnGenericType(m);
    }

    private void recordParametricReturnedType(Type parametricReturnType) {
        if (parametricReturnType instanceof ParameterizedType) {
            this.pCtx.setLastTypeParameters(((ParameterizedType)parametricReturnType).getActualTypeArguments());
            ParameterizedType pt = (ParameterizedType)parametricReturnType;
            Type[] gpt = pt.getActualTypeArguments();
            TypeVariable<Class<?>>[] classArgs = PropertyVerifier.type2Class(pt.getRawType()).getTypeParameters();
            if (gpt.length > 0 && this.paramTypes == null) {
                this.paramTypes = new HashMap<String, Type>();
            }
            for (int i = 0; i < gpt.length; ++i) {
                this.paramTypes.put(classArgs[i].toString(), gpt[i]);
            }
        }
    }

    private Class<?> returnGenericType(Method m) {
        Type parametricReturnType = m.getGenericReturnType();
        this.recordParametricReturnedType(parametricReturnType);
        String returnTypeArg = parametricReturnType.toString();
        if (parametricReturnType instanceof ParameterizedType) {
            this.pCtx.setLastTypeParameters(((ParameterizedType)parametricReturnType).getActualTypeArguments());
        }
        if (this.paramTypes != null && this.paramTypes.containsKey(returnTypeArg)) {
            return PropertyVerifier.type2Class(this.paramTypes.get(returnTypeArg));
        }
        return m.getReturnType();
    }

    private Class getCollectionProperty(Class ctx, String property) {
        if (this.first) {
            if (this.pCtx.hasVarOrInput(property)) {
                ctx = ParseTools.getSubComponentType(this.pCtx.getVarOrInputType(property));
            } else if (this.pCtx.hasImport(property)) {
                this.resolvedExternally = false;
                ctx = ParseTools.getSubComponentType(this.pCtx.getImport(property));
            } else {
                ctx = Object.class;
            }
        }
        if (this.pCtx.isStrictTypeEnforcement()) {
            if (Map.class.isAssignableFrom(property.length() != 0 ? (ctx = this.getBeanProperty(ctx, property)) : ctx)) {
                ctx = PropertyVerifier.type2Class(this.pCtx.getLastTypeParameters() != null && this.pCtx.getLastTypeParameters().length != 0 ? this.pCtx.getLastTypeParameters()[1] : Object.class);
            } else if (Collection.class.isAssignableFrom(ctx)) {
                ctx = this.pCtx.getLastTypeParameters() == null || this.pCtx.getLastTypeParameters().length == 0 ? Object.class : PropertyVerifier.type2Class(this.pCtx.getLastTypeParameters()[0]);
            } else if (ctx.isArray()) {
                ctx = ctx.getComponentType();
            } else if (this.pCtx.isStrongTyping()) {
                throw new CompileException("unknown collection type: " + ctx + "; property=" + property, this.expr, this.start);
            }
        } else {
            ctx = Object.class;
        }
        ++this.cursor;
        this.skipWhitespace();
        int start = this.cursor;
        if (this.scanTo(']')) {
            this.addFatalError("unterminated [ in token");
        }
        MVEL.analysisCompile(new String(this.expr, start, this.cursor - start), this.pCtx);
        ++this.cursor;
        return ctx;
    }

    private Class getMethod(Class ctx, String name) {
        StringAppender errorBuild;
        int i;
        Class[] args;
        int st = this.cursor;
        if (this.first) {
            this.first = false;
            this.methodCall = true;
            if (this.pCtx.hasImport(name)) {
                Method m = this.pCtx.getStaticImport(name).getMethod();
                ctx = m.getDeclaringClass();
                name = m.getName();
            } else {
                Function f = this.pCtx.getFunction(name);
                if (f != null && f.getEgressType() != null) {
                    this.resolvedExternally = false;
                    this.cursor = ParseTools.balancedCapture(this.expr, this.cursor, this.end, '(');
                    f.checkArgumentCount(ParseTools.parseParameterList(this.cursor - st > 1 ? ParseTools.subset(this.expr, st + 1, this.cursor - st - 1) : new char[]{}, 0, -1).size());
                    return f.getEgressType();
                }
                if (this.pCtx.hasVarOrInput("this")) {
                    if (this.pCtx.isStrictTypeEnforcement()) {
                        this.recordTypeParmsForProperty("this");
                    }
                    ctx = this.pCtx.getVarOrInputType("this");
                    this.resolvedExternally = false;
                }
            }
        }
        String tk = this.cursor < this.end && this.expr[this.cursor] == '(' && (this.cursor = ParseTools.balancedCapture(this.expr, this.cursor, this.end, '(')) - st > 1 ? new String(this.expr, st + 1, this.cursor - st - 1) : "";
        ++this.cursor;
        List<Object> subtokens = ParseTools.parseParameterList(tk.toCharArray(), 0, -1);
        if (subtokens.size() == 0) {
            args = new Class[]{};
            subtokens = Collections.emptyList();
        } else {
            args = new Class[subtokens.size()];
            List<ErrorDetail> errors = this.pCtx.getErrorList().isEmpty() ? this.pCtx.getErrorList() : new ArrayList<ErrorDetail>(this.pCtx.getErrorList());
            CompileException rethrow = null;
            for (i = 0; i < subtokens.size(); ++i) {
                try {
                    args[i] = MVEL.analyze((char[])subtokens.get(i), this.pCtx);
                    if ("null".equals(String.valueOf((char[])subtokens.get(i)))) {
                        args[i] = NullType.class;
                    }
                }
                catch (CompileException e) {
                    rethrow = ErrorUtil.rewriteIfNeeded(e, this.expr, this.st);
                }
                if (errors.size() < this.pCtx.getErrorList().size()) {
                    for (ErrorDetail detail : this.pCtx.getErrorList()) {
                        if (errors.contains(detail)) continue;
                        detail.setExpr(this.expr);
                        detail.setCursor(new String(this.expr).substring(this.st).indexOf(new String((char[])subtokens.get(i))) + this.st);
                        detail.setColumn(0);
                        detail.setLineNumber(0);
                        detail.calcRowAndColumn();
                    }
                }
                if (rethrow == null) continue;
                throw rethrow;
            }
        }
        Method m = ParseTools.getBestCandidate(args, name, ctx, ctx.getMethods(), this.pCtx.isStrongTyping());
        if (m == null && (m = ParseTools.getBestCandidate(args, name, ctx, ctx.getDeclaredMethods(), this.pCtx.isStrongTyping())) == null) {
            errorBuild = new StringAppender();
            for (i = 0; i < args.length; ++i) {
                errorBuild.append(args[i] != null ? args[i].getName() : null);
                if (i >= args.length - 1) continue;
                errorBuild.append(", ");
            }
            if (("size".equals(name) || "length".equals(name)) && args.length == 0 && ctx.isArray()) {
                return Integer.class;
            }
            if (this.pCtx.isStrictTypeEnforcement()) {
                throw new CompileException("unable to resolve method using strict-mode: " + ctx.getName() + "." + name + "(" + errorBuild.toString() + ")", this.expr, this.tkStart);
            }
            return Object.class;
        }
        if (this.pCtx.isStrictTypeEnforcement() && m.getGenericReturnType() != null) {
            HashMap<String, Class<Object>> typeArgs = new HashMap<String, Class<Object>>();
            Type[] gpt = m.getGenericParameterTypes();
            for (int i2 = 0; i2 < gpt.length; ++i2) {
                if (!(gpt[i2] instanceof ParameterizedType)) continue;
                ParameterizedType pt = (ParameterizedType)gpt[i2];
                Class z = this.pCtx.getImport(new String((char[])subtokens.get(i2)));
                if (z == null) continue;
                if (pt.getRawType().equals(Class.class)) {
                    typeArgs.put(pt.getActualTypeArguments()[0].toString(), z);
                    continue;
                }
                typeArgs.put(gpt[i2].toString(), z);
            }
            if (this.pCtx.isStrictTypeEnforcement() && ctx.getTypeParameters().length != 0 && this.pCtx.getLastTypeParameters() != null && this.pCtx.getLastTypeParameters().length == ctx.getTypeParameters().length) {
                TypeVariable<Class<T>>[] typeVariables = ctx.getTypeParameters();
                for (int i3 = 0; i3 < typeVariables.length; ++i3) {
                    Type typeArg = this.pCtx.getLastTypeParameters()[i3];
                    typeArgs.put(typeVariables[i3].getName(), typeArg instanceof Class ? PropertyVerifier.type2Class(this.pCtx.getLastTypeParameters()[i3]) : Object.class);
                }
            }
            Type parametricReturnType = m.getGenericReturnType();
            String returnTypeArg = parametricReturnType.toString();
            if (parametricReturnType instanceof ParameterizedType) {
                this.pCtx.setLastTypeParameters(((ParameterizedType)parametricReturnType).getActualTypeArguments());
            }
            if (this.paramTypes != null && this.paramTypes.containsKey(returnTypeArg)) {
                return PropertyVerifier.type2Class(this.paramTypes.get(returnTypeArg));
            }
            if (typeArgs.containsKey(returnTypeArg)) {
                return (Class)typeArgs.get(returnTypeArg);
            }
        }
        if (!Modifier.isPublic(m.getModifiers()) && this.pCtx.isStrictTypeEnforcement()) {
            errorBuild = new StringAppender();
            for (i = 0; i < args.length; ++i) {
                errorBuild.append(args[i] != null ? args[i].getName() : null);
                if (i >= args.length - 1) continue;
                errorBuild.append(", ");
            }
            String scope = Modifier.toString(m.getModifiers());
            if (scope.trim().equals("")) {
                scope = "<package local>";
            }
            this.addFatalError("the referenced method is not accessible: " + ctx.getName() + "." + name + "(" + errorBuild.toString() + ") (scope: " + scope + "; required: public", this.tkStart);
        }
        return this.getReturnType(ctx, m);
    }

    private static Class<?> type2Class(Type type) {
        if (type == null) {
            return null;
        }
        if (type instanceof Class) {
            return (Class)type;
        }
        if (type instanceof ParameterizedType) {
            return PropertyVerifier.type2Class(((ParameterizedType)type).getRawType());
        }
        if (type instanceof TypeVariable) {
            Object genericDeclaration = ((TypeVariable)type).getGenericDeclaration();
            return genericDeclaration instanceof Method ? ((Method)genericDeclaration).getReturnType() : Object.class;
        }
        throw new UnsupportedOperationException("Unknown type " + type);
    }

    private Class getWithProperty(Class ctx) {
        String root = new String(this.expr, 0, this.cursor - 1).trim();
        int start = this.cursor + 1;
        this.cursor = ParseTools.balancedCaptureWithLineAccounting(this.expr, this.cursor, this.end, '{', this.pCtx);
        int n = this.cursor++;
        new WithAccessor(this.pCtx, root, this.expr, start, n - start, ctx);
        return ctx;
    }

    public boolean isResolvedExternally() {
        return this.resolvedExternally;
    }

    public boolean isClassLiteral() {
        return this.classLiteral;
    }

    public boolean isDeepProperty() {
        return this.deepProperty;
    }

    public boolean isInput() {
        return this.resolvedExternally && !this.methodCall;
    }

    public boolean isMethodCall() {
        return this.methodCall;
    }

    public boolean isFqcn() {
        return this.fqcn;
    }

    public Class getCtx() {
        return this.ctx;
    }

    public void setCtx(Class ctx) {
        this.ctx = ctx;
    }
}

