/*
 * Decompiled with CFR 0.152.
 */
package org.jf.dexlib2.dexbacked;

import java.io.UnsupportedEncodingException;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.jf.dexlib2.Opcodes;
import org.jf.dexlib2.dexbacked.CDexBackedMethodImplementation;
import org.jf.dexlib2.dexbacked.DexBackedDexFile;
import org.jf.dexlib2.dexbacked.DexBackedMethod;
import org.jf.dexlib2.dexbacked.DexBackedMethodImplementation;
import org.jf.dexlib2.dexbacked.DexBuffer;
import org.jf.dexlib2.dexbacked.raw.CdexHeaderItem;
import org.jf.dexlib2.util.DexUtil;

public class CDexBackedDexFile
extends DexBackedDexFile {
    public CDexBackedDexFile(@Nullable Opcodes opcodes, @Nonnull byte[] buf, int offset, boolean verifyMagic) {
        super(opcodes, buf, offset, verifyMagic);
    }

    public CDexBackedDexFile(@Nullable Opcodes opcodes, @Nonnull DexBuffer buf) {
        super(opcodes, buf);
    }

    public CDexBackedDexFile(@Nullable Opcodes opcodes, @Nonnull byte[] buf, int offset) {
        super(opcodes, buf, offset);
    }

    public CDexBackedDexFile(@Nullable Opcodes opcodes, @Nonnull byte[] buf) {
        super(opcodes, buf);
    }

    public static boolean isCdex(byte[] buf, int offset) {
        byte[] cdexMagic;
        if (offset + 4 > buf.length) {
            return false;
        }
        try {
            cdexMagic = "cdex".getBytes("US-ASCII");
        }
        catch (UnsupportedEncodingException ex) {
            throw new RuntimeException(ex);
        }
        return buf[offset] == cdexMagic[0] && buf[offset + 1] == cdexMagic[1] && buf[offset + 2] == cdexMagic[2] && buf[offset + 3] == cdexMagic[3];
    }

    @Override
    protected int getVersion(byte[] buf, int offset, boolean verifyMagic) {
        if (verifyMagic) {
            return DexUtil.verifyCdexHeader(buf, offset);
        }
        return CdexHeaderItem.getVersion(buf, offset);
    }

    @Override
    protected Opcodes getDefaultOpcodes(int version2) {
        return Opcodes.forApi(28);
    }

    @Override
    public int getBaseDataOffset() {
        return this.getBuffer().readSmallUint(108);
    }

    public int getDebugInfoOffsetsPos() {
        return this.getBuffer().readSmallUint(116);
    }

    public int getDebugInfoOffsetsTableOffset() {
        return this.getBuffer().readSmallUint(120);
    }

    public int getDebugInfoBase() {
        return this.getBuffer().readSmallUint(124);
    }

    @Override
    protected DexBackedMethodImplementation createMethodImplementation(@Nonnull DexBackedDexFile dexFile, @Nonnull DexBackedMethod method, int codeOffset) {
        return new CDexBackedMethodImplementation(dexFile, method, codeOffset);
    }
}

