/*
 * Decompiled with CFR 0.152.
 */
package soot.JastAddJ;

import java.util.ArrayList;
import java.util.Collection;
import soot.JastAddJ.ASTNode;
import soot.JastAddJ.ASTNode$State;
import soot.JastAddJ.Access;
import soot.JastAddJ.Expr;
import soot.JastAddJ.GenericTypeDecl;
import soot.JastAddJ.List;
import soot.JastAddJ.ParTypeDecl;
import soot.JastAddJ.SimpleSet;
import soot.JastAddJ.TypeDecl;
import soot.JastAddJ.TypeVariable;

public class ParTypeAccess
extends Access
implements Cloneable {
    protected boolean type_computed = false;
    protected TypeDecl type_value;

    @Override
    public void flushCache() {
        super.flushCache();
        this.type_computed = false;
        this.type_value = null;
    }

    @Override
    public void flushCollectionCache() {
        super.flushCollectionCache();
    }

    @Override
    public ParTypeAccess clone() throws CloneNotSupportedException {
        ParTypeAccess node = (ParTypeAccess)super.clone();
        node.type_computed = false;
        node.type_value = null;
        node.in$Circle(false);
        node.is$Final(false);
        return node;
    }

    public ParTypeAccess copy() {
        try {
            ParTypeAccess node = this.clone();
            node.parent = null;
            if (this.children != null) {
                node.children = (ASTNode[])this.children.clone();
            }
            return node;
        }
        catch (CloneNotSupportedException e) {
            throw new Error("Error: clone not supported for " + this.getClass().getName());
        }
    }

    public ParTypeAccess fullCopy() {
        ParTypeAccess tree = this.copy();
        if (this.children != null) {
            for (int i = 0; i < this.children.length; ++i) {
                ASTNode child = this.children[i];
                if (child == null) continue;
                child = child.fullCopy();
                tree.setChild(child, i);
            }
        }
        return tree;
    }

    public boolean isRaw() {
        return false;
    }

    @Override
    public void typeCheck() {
        super.typeCheck();
        if (!this.genericDecl().isUnknown()) {
            TypeDecl type = this.type();
            if (!this.genericDecl().isGenericType()) {
                this.error(this.genericDecl().typeName() + " is not a generic type but used as one in " + this);
            } else if (!type.isRawType() && type.isNestedType() && type.enclosingType().isRawType()) {
                this.error("Can not access a member type of a raw type as a parameterized type");
            } else {
                GenericTypeDecl decl = (GenericTypeDecl)((Object)this.genericDecl());
                GenericTypeDecl original = (GenericTypeDecl)((Object)decl.original());
                if (original.getNumTypeParameter() != this.getNumTypeArgument()) {
                    this.error(decl.typeName() + " takes " + original.getNumTypeParameter() + " type parameters, not " + this.getNumTypeArgument() + " as used in " + this);
                } else {
                    ParTypeDecl typeDecl = (ParTypeDecl)((Object)this.type());
                    for (int i = 0; i < this.getNumTypeArgument(); ++i) {
                        if (this.getTypeArgument(i).type().instanceOf(original.getTypeParameter(i))) continue;
                        this.error("type argument " + i + " is of type " + this.getTypeArgument(i).type().typeName() + " which is not a subtype of " + original.getTypeParameter(i).typeName());
                    }
                }
            }
        }
    }

    @Override
    public void toString(StringBuffer s) {
        this.getTypeAccess().toString(s);
        s.append("<");
        for (int i = 0; i < this.getNumTypeArgument(); ++i) {
            if (i != 0) {
                s.append(", ");
            }
            this.getTypeArgument(i).toString(s);
        }
        s.append(">");
    }

    public ParTypeAccess() {
    }

    @Override
    public void init$Children() {
        this.children = new ASTNode[2];
        this.setChild(new List(), 1);
    }

    public ParTypeAccess(Access p0, List<Access> p1) {
        this.setChild(p0, 0);
        this.setChild(p1, 1);
    }

    @Override
    protected int numChildren() {
        return 2;
    }

    @Override
    public boolean mayHaveRewrite() {
        return false;
    }

    public void setTypeAccess(Access node) {
        this.setChild(node, 0);
    }

    public Access getTypeAccess() {
        return (Access)this.getChild(0);
    }

    public Access getTypeAccessNoTransform() {
        return (Access)this.getChildNoTransform(0);
    }

    public void setTypeArgumentList(List<Access> list) {
        this.setChild(list, 1);
    }

    public int getNumTypeArgument() {
        return this.getTypeArgumentList().getNumChild();
    }

    public int getNumTypeArgumentNoTransform() {
        return this.getTypeArgumentListNoTransform().getNumChildNoTransform();
    }

    public Access getTypeArgument(int i) {
        return (Access)this.getTypeArgumentList().getChild(i);
    }

    public void addTypeArgument(Access node) {
        List<Access> list = this.parent == null || state == null ? this.getTypeArgumentListNoTransform() : this.getTypeArgumentList();
        list.addChild(node);
    }

    public void addTypeArgumentNoTransform(Access node) {
        List<Access> list = this.getTypeArgumentListNoTransform();
        list.addChild(node);
    }

    public void setTypeArgument(Access node, int i) {
        List<Access> list = this.getTypeArgumentList();
        list.setChild(node, i);
    }

    public List<Access> getTypeArguments() {
        return this.getTypeArgumentList();
    }

    public List<Access> getTypeArgumentsNoTransform() {
        return this.getTypeArgumentListNoTransform();
    }

    public List<Access> getTypeArgumentList() {
        List list = (List)this.getChild(1);
        list.getNumChild();
        return list;
    }

    public List<Access> getTypeArgumentListNoTransform() {
        return (List)this.getChildNoTransform(1);
    }

    @Override
    public Expr unqualifiedScope() {
        ASTNode$State state = this.state();
        return this.getParent() instanceof Access ? ((Access)this.getParent()).unqualifiedScope() : super.unqualifiedScope();
    }

    @Override
    public TypeDecl type() {
        if (this.type_computed) {
            return this.type_value;
        }
        ASTNode$State state = this.state();
        int num = state.boundariesCrossed;
        boolean isFinal = this.is$Final();
        this.type_value = this.type_compute();
        if (isFinal && num == this.state().boundariesCrossed) {
            this.type_computed = true;
        }
        return this.type_value;
    }

    private TypeDecl type_compute() {
        TypeDecl typeDecl = this.genericDecl();
        if (typeDecl instanceof GenericTypeDecl) {
            if (this.unqualifiedScope().inExtendsOrImplements()) {
                return ((GenericTypeDecl)((Object)typeDecl)).lookupParTypeDecl(this);
            }
            ArrayList<TypeDecl> args = new ArrayList<TypeDecl>();
            for (int i = 0; i < this.getNumTypeArgument(); ++i) {
                args.add(this.getTypeArgument(i).type());
            }
            return ((GenericTypeDecl)((Object)typeDecl)).lookupParTypeDecl(args);
        }
        return typeDecl;
    }

    public TypeDecl genericDecl() {
        ASTNode$State state = this.state();
        return this.getTypeAccess().type();
    }

    @Override
    public boolean isTypeAccess() {
        ASTNode$State state = this.state();
        return true;
    }

    @Override
    public Access substituted(Collection<TypeVariable> original, List<TypeVariable> substitution) {
        ASTNode$State state = this.state();
        List<Access> substArgs = new List<Access>();
        for (Access arg : this.getTypeArgumentList()) {
            substArgs.add(arg.substituted(original, substitution));
        }
        return new ParTypeAccess(this.getTypeAccess().substituted(original, substitution), substArgs);
    }

    @Override
    public SimpleSet Define_SimpleSet_lookupType(ASTNode caller, ASTNode child, String name) {
        if (caller == this.getTypeArgumentListNoTransform()) {
            int childIndex = caller.getIndexOfChild(child);
            return this.unqualifiedScope().lookupType(name);
        }
        return this.getParent().Define_SimpleSet_lookupType(this, caller, name);
    }

    @Override
    public ASTNode rewriteTo() {
        return super.rewriteTo();
    }
}

