/*
 * Decompiled with CFR 0.152.
 */
package soot;

import java.io.IOException;
import java.io.InputStream;
import java.util.Iterator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import soot.ClassSource;
import soot.FoundFile;
import soot.RefType;
import soot.SootClass;
import soot.SootMethod;
import soot.SootResolver;
import soot.javaToJimple.IInitialResolver;
import soot.jimple.JimpleMethodSource;
import soot.jimple.parser.JimpleAST;
import soot.jimple.parser.lexer.LexerException;
import soot.jimple.parser.parser.ParserException;
import soot.options.Options;

public class JimpleClassSource
extends ClassSource {
    private static final Logger logger = LoggerFactory.getLogger(JimpleClassSource.class);
    private FoundFile foundFile;

    public JimpleClassSource(String className, FoundFile foundFile) {
        super(className);
        if (foundFile == null) {
            throw new IllegalStateException("Error: The FoundFile must not be null.");
        }
        this.foundFile = foundFile;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public IInitialResolver.Dependencies resolve(SootClass sc) {
        if (Options.v().verbose()) {
            logger.debug("resolving [from .jimple]: " + this.className);
        }
        InputStream classFile = null;
        try {
            String className;
            classFile = this.foundFile.inputStream();
            JimpleAST jimpAST = new JimpleAST(classFile);
            jimpAST.getSkeleton(sc);
            JimpleMethodSource mtdSrc = new JimpleMethodSource(jimpAST);
            Iterator<SootMethod> mtdIt = sc.methodIterator();
            while (mtdIt.hasNext()) {
                SootMethod sm = mtdIt.next();
                sm.setSource(mtdSrc);
            }
            String outerClassName = null;
            if (!sc.hasOuterClass() && (className = sc.getName()).contains("$")) {
                outerClassName = className.contains("$-") ? className.substring(0, className.indexOf("$-")) : className.substring(0, className.lastIndexOf(36));
                sc.setOuterClass(SootResolver.v().makeClassRef(outerClassName));
            }
            IInitialResolver.Dependencies deps = new IInitialResolver.Dependencies();
            for (String t : jimpAST.getCstPool()) {
                deps.typesToSignature.add(RefType.v(t));
            }
            if (outerClassName != null) {
                deps.typesToSignature.add(RefType.v(outerClassName));
            }
            IInitialResolver.Dependencies dependencies = deps;
            return dependencies;
        }
        catch (IOException e) {
            throw new RuntimeException("Error: Failed to create JimpleAST from source input stream for class " + this.className + ".", e);
        }
        catch (ParserException e) {
            throw new RuntimeException("Error: Failed when parsing class " + this.className + ".", e);
        }
        catch (LexerException e) {
            throw new RuntimeException("Error: Failed when lexing class " + this.className + ".", e);
        }
        finally {
            try {
                if (classFile != null) {
                    classFile.close();
                    classFile = null;
                }
            }
            catch (IOException e) {
                throw new RuntimeException("Error: Failed to close source input stream.", e);
            }
            finally {
                this.close();
            }
        }
    }

    @Override
    public void close() {
        if (this.foundFile != null) {
            this.foundFile.close();
            this.foundFile = null;
        }
    }
}

