/*
 * Decompiled with CFR 0.152.
 */
package soot;

import com.google.common.base.Optional;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import soot.Body;
import soot.Hierarchy;
import soot.ModuleRefType;
import soot.ModuleUtil;
import soot.RefType;
import soot.Scene;
import soot.SootClass;
import soot.Trap;
import soot.Unit;
import soot.UnitPatchingChain;
import soot.util.Chain;

public class TrapManager {
    public static boolean isExceptionCaughtAt(SootClass e, Unit u, Body b) {
        Hierarchy h = Scene.v().getActiveHierarchy();
        UnitPatchingChain units = b.getUnits();
        for (Trap t : b.getTraps()) {
            if (!h.isClassSubclassOfIncluding(e, t.getException())) continue;
            Iterator<Unit> it = units.iterator(t.getBeginUnit(), units.getPredOf(t.getEndUnit()));
            while (it.hasNext()) {
                if (!u.equals(it.next())) continue;
                return true;
            }
        }
        return false;
    }

    public static List<Trap> getTrapsAt(Unit unit, Body b) {
        UnitPatchingChain units = b.getUnits();
        ArrayList<Trap> trapsList = new ArrayList<Trap>();
        for (Trap t : b.getTraps()) {
            Iterator<Unit> it = units.iterator(t.getBeginUnit(), units.getPredOf(t.getEndUnit()));
            while (it.hasNext()) {
                if (!unit.equals(it.next())) continue;
                trapsList.add(t);
            }
        }
        return trapsList;
    }

    public static Set<Unit> getTrappedUnitsOf(Body b) {
        UnitPatchingChain units = b.getUnits();
        HashSet<Unit> trapsSet = new HashSet<Unit>();
        for (Trap t : b.getTraps()) {
            Iterator<Unit> it = units.iterator(t.getBeginUnit(), units.getPredOf(t.getEndUnit()));
            while (it.hasNext()) {
                trapsSet.add(it.next());
            }
        }
        return trapsSet;
    }

    public static void splitTrapsAgainst(Body b, Unit rangeStart, Unit rangeEnd) {
        Chain<Trap> traps = b.getTraps();
        UnitPatchingChain units = b.getUnits();
        Iterator<Trap> trapsIt = traps.snapshotIterator();
        block0: while (trapsIt.hasNext()) {
            Trap t = trapsIt.next();
            boolean insideRange = false;
            Iterator<Unit> unitIt = units.iterator(t.getBeginUnit(), t.getEndUnit());
            while (unitIt.hasNext()) {
                Unit u = unitIt.next();
                if (rangeStart.equals(u)) {
                    insideRange = true;
                }
                if (!unitIt.hasNext()) {
                    if (!insideRange) continue block0;
                    Trap newTrap = (Trap)t.clone();
                    t.setBeginUnit(rangeStart);
                    newTrap.setEndUnit(rangeStart);
                    traps.insertAfter(newTrap, t);
                }
                if (!rangeEnd.equals(u)) continue;
                if (!insideRange) {
                    throw new RuntimeException("inversed range?");
                }
                Trap firstTrap = (Trap)t.clone();
                Trap secondTrap = (Trap)t.clone();
                firstTrap.setEndUnit(rangeStart);
                secondTrap.setBeginUnit(rangeStart);
                secondTrap.setEndUnit(rangeEnd);
                t.setBeginUnit(rangeEnd);
                traps.insertAfter(firstTrap, t);
                traps.insertAfter(secondTrap, t);
            }
        }
    }

    public static List<RefType> getExceptionTypesOf(Unit u, Body body) {
        boolean module_mode = ModuleUtil.module_mode();
        ArrayList<RefType> possibleTypes = new ArrayList<RefType>();
        for (Trap trap : body.getTraps()) {
            if (trap.getHandlerUnit() != u) continue;
            RefType type = module_mode ? ModuleRefType.v(trap.getException().getName(), Optional.fromNullable(trap.getException().moduleName)) : RefType.v(trap.getException().getName());
            possibleTypes.add(type);
        }
        return possibleTypes;
    }
}

