/*
 * Decompiled with CFR 0.152.
 */
package soot.asm;

import java.io.IOException;
import java.nio.file.DirectoryStream;
import java.nio.file.FileSystemNotFoundException;
import java.nio.file.Files;
import java.nio.file.Path;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import soot.ClassProvider;
import soot.ClassSource;
import soot.FoundFile;
import soot.ModulePathSourceLocator;
import soot.asm.AsmClassSource;

public class AsmJava9ClassProvider
implements ClassProvider {
    private static final Logger logger = LoggerFactory.getLogger(AsmJava9ClassProvider.class);

    @Override
    public ClassSource find(String cls) {
        String clsFile = cls.replace('.', '/') + ".class";
        FoundFile file = null;
        Path p = ModulePathSourceLocator.getRootModulesPathOfJDK();
        try (DirectoryStream<Path> stream = Files.newDirectoryStream(p);){
            for (Path entry : stream) {
                file = ModulePathSourceLocator.v().lookUpInVirtualFileSystem(entry.toUri().toString(), clsFile);
                if (file == null) continue;
                break;
            }
        }
        catch (FileSystemNotFoundException ex) {
            logger.debug("Could not read my modules (perhaps not Java 9?).");
        }
        catch (IOException e) {
            logger.debug(e.getMessage(), e);
        }
        return file == null ? null : new AsmClassSource(cls, file);
    }
}

