/*
 * Decompiled with CFR 0.152.
 */
package soot.baf;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import soot.Body;
import soot.DoubleType;
import soot.Local;
import soot.LongType;
import soot.PackManager;
import soot.SootMethod;
import soot.Trap;
import soot.Type;
import soot.Unit;
import soot.UnitBox;
import soot.baf.Baf;
import soot.baf.DoubleWordType;
import soot.baf.PlaceholderInst;
import soot.baf.WordType;
import soot.baf.internal.BafLocal;
import soot.jimple.ConvertToBaf;
import soot.jimple.JimpleBody;
import soot.jimple.JimpleToBafContext;
import soot.options.Options;

public class BafBody
extends Body {
    private static final Logger logger = LoggerFactory.getLogger(BafBody.class);
    private final JimpleToBafContext jimpleToBafContext;

    public BafBody(JimpleBody jimpleBody, Map<String, String> options) {
        super(jimpleBody.getMethod());
        JimpleToBafContext context;
        if (Options.v().verbose()) {
            logger.debug("[" + this.getMethod().getName() + "] Constructing BafBody...");
        }
        this.jimpleToBafContext = context = new JimpleToBafContext(jimpleBody.getLocalCount());
        for (Local l : jimpleBody.getLocals()) {
            Type t = l.getType();
            t = DoubleType.v().equals(t) || LongType.v().equals(t) ? DoubleWordType.v() : WordType.v();
            BafLocal newLocal = (BafLocal)Baf.v().newLocal(l.getName(), t);
            context.setBafLocalOfJimpleLocal(l, newLocal);
            newLocal.setOriginalLocal(l);
            this.getLocals().add(newLocal);
        }
        assert (this.getLocals().size() == jimpleBody.getLocalCount());
        HashMap origToFirstConverted = new HashMap();
        for (Unit u : jimpleBody.getUnits()) {
            ArrayList<Unit> conversionList = new ArrayList<Unit>();
            context.setCurrentUnit(u);
            ((ConvertToBaf)((Object)u)).convertToBaf(context, conversionList);
            origToFirstConverted.put(u, conversionList.get(0));
            this.getUnits().addAll(conversionList);
        }
        for (UnitBox box : this.getAllUnitBoxes()) {
            Unit unit = box.getUnit();
            if (!(unit instanceof PlaceholderInst)) continue;
            Unit source = ((PlaceholderInst)unit).getSource();
            box.setUnit((Unit)origToFirstConverted.get(source));
        }
        for (Trap trap : jimpleBody.getTraps()) {
            this.getTraps().add(Baf.v().newTrap(trap.getException(), (Unit)origToFirstConverted.get(trap.getBeginUnit()), (Unit)origToFirstConverted.get(trap.getEndUnit()), (Unit)origToFirstConverted.get(trap.getHandlerUnit())));
        }
        PackManager.v().getPack("bb").apply(this);
    }

    BafBody(SootMethod m) {
        super(m);
        this.jimpleToBafContext = null;
    }

    public JimpleToBafContext getContext() {
        return this.jimpleToBafContext;
    }

    @Override
    public Object clone() {
        BafBody b = new BafBody(this.getMethodUnsafe());
        b.importBodyContentsFrom(this);
        return b;
    }
}

