/*
 * Decompiled with CFR 0.152.
 */
package soot.dexpler;

import java.util.Iterator;
import java.util.Map;
import soot.Body;
import soot.BodyTransformer;
import soot.Unit;
import soot.Value;
import soot.jimple.BinopExpr;
import soot.jimple.IfStmt;
import soot.jimple.IntConstant;
import soot.jimple.NullConstant;

public class DexNullIfTransformer
extends BodyTransformer {
    private boolean hasModifiedBody;

    public static DexNullIfTransformer v() {
        return new DexNullIfTransformer();
    }

    @Override
    protected void internalTransform(Body b, String phaseName, Map<String, String> options) {
        NullConstant nullC = NullConstant.v();
        Iterator unitIt = b.getUnits().snapshotIterator();
        while (unitIt.hasNext()) {
            IfStmt ifStmt;
            Value o;
            Unit u = (Unit)unitIt.next();
            if (!(u instanceof IfStmt) || !((o = (ifStmt = (IfStmt)u).getCondition()) instanceof BinopExpr)) continue;
            BinopExpr bop = (BinopExpr)o;
            Value l = bop.getOp1();
            Value r = bop.getOp2();
            if (!this.isNull(l) || !this.isNull(r) || !(l instanceof NullConstant) && !(r instanceof NullConstant)) continue;
            bop.setOp1(nullC);
            bop.setOp2(nullC);
            this.hasModifiedBody = true;
        }
    }

    private boolean isNull(Value l) {
        if (l instanceof NullConstant) {
            return true;
        }
        return l instanceof IntConstant && ((IntConstant)l).value == 0;
    }

    public boolean hasModifiedBody() {
        return this.hasModifiedBody;
    }
}

