/*
 * Decompiled with CFR 0.152.
 */
package soot.dexpler.instructions;

import java.util.Arrays;
import java.util.List;
import org.jf.dexlib2.iface.instruction.DualReferenceInstruction;
import org.jf.dexlib2.iface.instruction.Instruction;
import org.jf.dexlib2.iface.reference.MethodProtoReference;
import soot.ArrayType;
import soot.Body;
import soot.Local;
import soot.RefType;
import soot.Scene;
import soot.SootMethodRef;
import soot.Type;
import soot.UnitPatchingChain;
import soot.dexpler.DexBody;
import soot.dexpler.instructions.MethodInvocationInstruction;
import soot.jimple.IntConstant;
import soot.jimple.Jimple;
import soot.jimple.internal.JArrayRef;
import soot.jimple.internal.JAssignStmt;
import soot.jimple.internal.JNewArrayExpr;
import soot.jimple.internal.JimpleLocal;

public class InvokePolymorphicInstruction
extends MethodInvocationInstruction {
    public InvokePolymorphicInstruction(Instruction instruction, int codeAddress) {
        super(instruction, codeAddress);
    }

    @Override
    public void jimplify(DexBody body) {
        SootMethodRef ref = this.getVirtualSootMethodRef();
        if (ref.declaringClass().isInterface()) {
            ref = this.getInterfaceSootMethodRef();
        }
        List<Local> temp = this.buildParameters(body, ((MethodProtoReference)((DualReferenceInstruction)this.instruction).getReference2()).getParameterTypes(), false);
        List<Local> parms = temp.subList(1, temp.size());
        Local invoker = temp.get(0);
        if (!(parms.size() <= 0 || parms.size() == 1 && parms.get(0) instanceof ArrayType)) {
            Body b = body.getBody();
            UnitPatchingChain units = b.getUnits();
            RefType rf = Scene.v().getRefType("java.lang.Object");
            JimpleLocal newArrL = new JimpleLocal("$u" + (b.getLocalCount() + 1), ArrayType.v(rf, 1));
            b.getLocals().add(newArrL);
            JAssignStmt newArr = new JAssignStmt(newArrL, new JNewArrayExpr((Type)rf, IntConstant.v(parms.size())));
            units.add(newArr);
            int i = 0;
            for (Local l : parms) {
                units.add(new JAssignStmt(new JArrayRef(newArrL, IntConstant.v(i)), l));
                ++i;
            }
            parms = Arrays.asList(newArrL);
        }
        this.invocation = ref.declaringClass().isInterface() ? Jimple.v().newInterfaceInvokeExpr(invoker, ref, parms) : Jimple.v().newVirtualInvokeExpr(invoker, ref, parms);
        body.setDanglingInstruction(this);
    }
}

