/*
 * Decompiled with CFR 0.152.
 */
package soot.jimple.internal;

import java.util.ArrayList;
import java.util.List;
import soot.UnitPrinter;
import soot.Value;
import soot.ValueBox;
import soot.grimp.PrecedenceTest;
import soot.jimple.Expr;

public abstract class AbstractBinopExpr
implements Expr {
    protected final ValueBox op1Box;
    protected final ValueBox op2Box;

    protected AbstractBinopExpr(ValueBox op1Box, ValueBox op2Box) {
        this.op1Box = op1Box;
        this.op2Box = op2Box;
    }

    protected abstract String getSymbol();

    @Override
    public abstract Object clone();

    public Value getOp1() {
        return this.op1Box.getValue();
    }

    public Value getOp2() {
        return this.op2Box.getValue();
    }

    public ValueBox getOp1Box() {
        return this.op1Box;
    }

    public ValueBox getOp2Box() {
        return this.op2Box;
    }

    public void setOp1(Value op1) {
        this.op1Box.setValue(op1);
    }

    public void setOp2(Value op2) {
        this.op2Box.setValue(op2);
    }

    @Override
    public final List<ValueBox> getUseBoxes() {
        ArrayList<ValueBox> list = new ArrayList<ValueBox>();
        list.addAll(this.op1Box.getValue().getUseBoxes());
        list.add(this.op1Box);
        list.addAll(this.op2Box.getValue().getUseBoxes());
        list.add(this.op2Box);
        return list;
    }

    @Override
    public boolean equivTo(Object o) {
        if (o instanceof AbstractBinopExpr) {
            AbstractBinopExpr abe = (AbstractBinopExpr)o;
            return this.op1Box.getValue().equivTo(abe.op1Box.getValue()) && this.op2Box.getValue().equivTo(abe.op2Box.getValue()) && this.getSymbol().equals(abe.getSymbol());
        }
        return false;
    }

    @Override
    public int equivHashCode() {
        return this.op1Box.getValue().equivHashCode() * 101 + this.op2Box.getValue().equivHashCode() + 17 ^ this.getSymbol().hashCode();
    }

    public String toString() {
        return this.op1Box.getValue().toString() + this.getSymbol() + this.op2Box.getValue().toString();
    }

    @Override
    public void toString(UnitPrinter up) {
        boolean needsBrackets = PrecedenceTest.needsBrackets(this.op1Box, this);
        if (needsBrackets) {
            up.literal("(");
        }
        this.op1Box.toString(up);
        if (needsBrackets) {
            up.literal(")");
        }
        up.literal(this.getSymbol());
        needsBrackets = PrecedenceTest.needsBracketsRight(this.op2Box, this);
        if (needsBrackets) {
            up.literal("(");
        }
        this.op2Box.toString(up);
        if (needsBrackets) {
            up.literal(")");
        }
    }
}

